/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.iqiyi;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.iqiyi.IqiyiConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class IqiyiRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(IqiyiRtbIntegration.class);
    public static final String CLICK_ID = "impress_id";
    private static final String EVENT_TYPE_APP_ORDER = "206";

    public IqiyiRtbIntegration(IqiyiConfig config) {
        super(config);
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String referrer = request.getReferrer();
        UriComponents build = UriComponentsBuilder.fromUriString((String)referrer).build();
        MultiValueMap queryParams = build.getQueryParams();
        String clickId = (String)queryParams.getFirst((Object)CLICK_ID);
        KeyValueMap clickTracker = this.getClickTracker(clickId);
        return Optional.ofNullable(clickTracker).map(k -> (String)k.getFirst((Object)"ad_group_id")).orElse("");
    }

    @Override
    public Rtb rtb() {
        return Rtb.iQiyi;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String payAmount;
        String url = this.getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        String impressId = (String)UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams().getFirst((Object)CLICK_ID);
        if (StringUtils.isBlank((String)impressId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'impressId' by referrer.");
        }
        HashMap params = Maps.newHashMap();
        params.put("conv_time", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("event_type", eventType);
        params.put(CLICK_ID, impressId);
        if (EVENT_TYPE_APP_ORDER.equals(eventType) && StringUtils.isNotBlank((String)(payAmount = (String)request.getKeyValueMap().getFirst((Object)"pay_amount")))) {
            int payAmountCent = new BigDecimal(payAmount).multiply(new BigDecimal(100)).intValue();
            params.put("pmao", payAmountCent);
        }
        url = OkHttpUtils.appendParams((String)url, (Map)params);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        return (FeedbackResponse)JsonHelper.convert((String)body, Response.class);
    }

    private static class Response
    extends FeedbackResponse {
        private String status;
        private String message;

        private Response() {
        }

        @Override
        public boolean isSuccess() {
            return StringUtils.equals((String)"200", (String)this.status);
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

