/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.jiguangadx;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.RtbConfig;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class JiguangAdxRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(JiguangAdxRtbIntegration.class);

    public JiguangAdxRtbIntegration(RtbConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.JiGuangAdx;
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return false;
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "req_id";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        MultiValueMap queryParams = UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams();
        String clickIdParameterNameOnReferrer = this.getClickIdParameterNameOnReferrer();
        String reqId = (String)queryParams.getFirst((Object)clickIdParameterNameOnReferrer);
        String chl = (String)queryParams.getFirst((Object)"chl");
        if (StringUtils.isBlank((String)reqId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found '" + clickIdParameterNameOnReferrer + "' by referrer.");
        }
        if (StringUtils.isBlank((String)chl)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'chl' by referrer.");
        }
        HashMap params = Maps.newHashMap();
        params.put("req_id", reqId);
        params.put("event", eventType);
        params.put("chl", chl);
        url = OkHttpUtils.appendParams((String)url, (Map)params);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }
}

