/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.kuaishou;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.adscounter.rtb.common.ClickTracker;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.kuaishou.KuaishouConfig;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class KuaishouRtbIntegration
extends AbstractClickTrackerRtbIntegration
implements ClickTracker {
    private static final Logger log = LoggerFactory.getLogger(KuaishouRtbIntegration.class);
    public static final String CLICK_ID = "callback";
    private final KuaishouConfig config;
    private static final String EVENT_TYPE_FORM = "9";

    public KuaishouRtbIntegration(KuaishouConfig config) {
        super(config);
        this.config = config;
    }

    @Override
    public boolean forceSaveClickTracker() {
        return true;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        String callback = (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
        if (StringUtils.isBlank((String)callback)) {
            log.info("Empty value for callback!");
            return null;
        }
        if (StringUtils.equals((String)clickTrackerKeyValueMap.getProduction(), (String)Production.INADS.getName()) && StringUtils.equals((String)clickTrackerKeyValueMap.getMt(), (String)Inads.Mt.IndexShow.original())) {
            return callback;
        }
        String url = UrlHelper.urlDecode((String)callback);
        return UrlHelper.getFirstValueOfParamName((String)url, (String)CLICK_ID);
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        String ref = clickEventLog.getRef();
        return UrlHelper.getFirstValueOfParamName((String)ref, (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String referrer = request.getReferrer();
        UriComponents build = UriComponentsBuilder.fromUriString((String)referrer).build();
        MultiValueMap queryParams = build.getQueryParams();
        String clickId = request.getClickId();
        if (StringUtils.isBlank((String)clickId)) {
            clickId = (String)queryParams.getFirst((Object)CLICK_ID);
        }
        KeyValueMap clickTracker = this.getClickTracker(clickId);
        return Optional.ofNullable(clickTracker).map(k -> (String)k.getFirst((Object)"ad_group_id")).orElse("");
    }

    @Override
    public String getApp(KeyValueMap keyValueMap) {
        String app;
        block3: {
            String ext = (String)keyValueMap.getFirst((Object)"ext");
            if (StringUtils.isBlank((String)ext)) {
                return null;
            }
            app = null;
            try {
                JSONObject jsonObject = JSONObject.parseObject((String)ext);
                app = jsonObject.getString("x_pkgname");
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("parseObject: '{}' on log: {}", (Object)e.getMessage(), (Object)keyValueMap);
            }
        }
        return app;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String eventType = request.getEventType();
        String referrer = request.getReferrer();
        String extend = this.getExtendAction(request);
        String callback = request.getClickId();
        if (StringUtils.isBlank((String)callback)) {
            UriComponents build = UriComponentsBuilder.fromUriString((String)referrer).build();
            MultiValueMap queryParams = build.getQueryParams();
            callback = (String)queryParams.getFirst((Object)CLICK_ID);
        }
        if (StringUtils.isBlank((String)callback)) {
            String bxmId = this.getBxmId(request);
            throw new RtbIntegrationException(FailType.NotFoundClickId, "[" + bxmId + "] \u65e0\u6cd5\u627e\u5230 callback \u503c\uff0c\u5728 Referrer (" + referrer + ") \u4e2d\u3002");
        }
        HashMap params = Maps.newHashMap();
        params.put(CLICK_ID, callback);
        params.put("event_type", eventType);
        params.put("event_time", String.valueOf(System.currentTimeMillis()));
        boolean isForm = Objects.equals(EVENT_TYPE_FORM, eventType);
        if (isForm && StringUtils.isNotBlank((String)extend)) {
            params.put("event_props", this.buildEventProps(extend));
        }
        String finalUrl = OkHttpUtils.appendParams((String)this.config.getUrl(), (Map)params);
        return new HttpGet(finalUrl);
    }

    private String getExtendAction(FeedbackRequest request) {
        PositionRtb positionRtb = request.getConfig();
        if (positionRtb == null) {
            return null;
        }
        String extend = positionRtb.getExtend();
        if (StringUtils.isNotBlank((String)extend)) {
            ActionExtend actionExtend = (ActionExtend)JsonHelper.convert((String)extend, ActionExtend.class);
            extend = request.isDeepConversion() ? actionExtend.getDeepAction() : actionExtend.getShallowAction();
        }
        return extend;
    }

    private String getBxmId(FeedbackRequest request) {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        return Optional.ofNullable(keyValueMap).map(e -> (String)e.getFirst((Object)"bxmid")).orElse("unknown");
    }

    private String buildEventProps(String extend) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("actionName", (Object)("EXTERNAL_ACTION" + extend));
        return jsonObject.toJSONString();
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        return (FeedbackResponse)JsonHelper.convert((String)body, KuaishouResponse.class);
    }

    @Override
    public Rtb rtb() {
        return Rtb.Kuaishou;
    }

    public static class ActionExtend {
        private String shallowAction;
        private String deepAction;

        public String getShallowAction() {
            return this.shallowAction;
        }

        public String getDeepAction() {
            return this.deepAction;
        }

        public void setShallowAction(String shallowAction) {
            this.shallowAction = shallowAction;
        }

        public void setDeepAction(String deepAction) {
            this.deepAction = deepAction;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ActionExtend)) {
                return false;
            }
            ActionExtend other = (ActionExtend)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$shallowAction = this.getShallowAction();
            String other$shallowAction = other.getShallowAction();
            if (this$shallowAction == null ? other$shallowAction != null : !this$shallowAction.equals(other$shallowAction)) {
                return false;
            }
            String this$deepAction = this.getDeepAction();
            String other$deepAction = other.getDeepAction();
            return !(this$deepAction == null ? other$deepAction != null : !this$deepAction.equals(other$deepAction));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ActionExtend;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $shallowAction = this.getShallowAction();
            result = result * 59 + ($shallowAction == null ? 43 : $shallowAction.hashCode());
            String $deepAction = this.getDeepAction();
            result = result * 59 + ($deepAction == null ? 43 : $deepAction.hashCode());
            return result;
        }

        public String toString() {
            return "KuaishouRtbIntegration.ActionExtend(shallowAction=" + this.getShallowAction() + ", deepAction=" + this.getDeepAction() + ")";
        }
    }

    private static class KuaishouResponse
    extends FeedbackResponse {
        private String result;
        @JSONField(name="host-name")
        private String hostName;

        private KuaishouResponse() {
        }

        @Override
        public boolean isSuccess() {
            return StringUtils.equalsIgnoreCase((String)"1", (String)this.result);
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }
    }
}

