/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.meituan;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.meituan.MeituanConfig;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class MeituanRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(MeituanRtbIntegration.class);
    private MeituanConfig config;

    public MeituanRtbIntegration(MeituanConfig config) {
        super(config);
        this.config = config;
    }

    @Override
    public Rtb rtb() {
        return Rtb.MeiTuan;
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "exposure_id";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        MultiValueMap queryParams = UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams();
        String aid = (String)queryParams.getFirst((Object)"aid");
        String cid = (String)queryParams.getFirst((Object)"cid");
        String clickIdParameterNameOnReferrer = this.getClickIdParameterNameOnReferrer();
        String exposure_id = (String)queryParams.getFirst((Object)clickIdParameterNameOnReferrer);
        if (StringUtils.isBlank((String)aid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'aid' by referrer.");
        }
        if (StringUtils.isBlank((String)cid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'cid' by referrer.");
        }
        if (StringUtils.isBlank((String)exposure_id)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found '" + clickIdParameterNameOnReferrer + "' by referrer.");
        }
        LinkedHashMap params = Maps.newLinkedHashMap();
        params.put("aid", aid);
        params.put("cid", cid);
        params.put("event_type", eventType);
        params.put("event_value", 0);
        params.put("timestamp", System.currentTimeMillis());
        params.put("exposure_id", exposure_id);
        params.put("sign", this.getSign(params));
        url = OkHttpUtils.appendParams((String)url, (Map)params);
        return new HttpGet(url);
    }

    private String getSign(Map<String, Object> params) {
        StringBuilder paramStringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (paramStringBuilder.length() > 0) {
                paramStringBuilder.append("&");
            }
            paramStringBuilder.append(entry.getKey()).append("=").append(entry.getValue());
        }
        paramStringBuilder.append(this.config.getKey());
        return DigestUtils.md5Hex((String)paramStringBuilder.toString());
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }
}

