/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.mintegraloverseas;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.mintegraloverseas.MintegralOverseasConfig;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class MintegralOverseasRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(MintegralOverseasRtbIntegration.class);

    public MintegralOverseasRtbIntegration(MintegralOverseasConfig config) {
        super(config);
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        MultiValueMap queryParams = UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams();
        String campuuid = (String)queryParams.getFirst((Object)"campaign_id");
        if (StringUtils.isBlank((String)campuuid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'campaign_id' by referrer.");
        }
        String clickIdParameterNameOnReferrer = this.getClickIdParameterNameOnReferrer();
        String clickid = (String)queryParams.getFirst((Object)clickIdParameterNameOnReferrer);
        if (StringUtils.isBlank((String)clickid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found '" + clickIdParameterNameOnReferrer + "' by referrer.");
        }
        HashMap params = Maps.newHashMap();
        params.put("clickid", clickid);
        params.put("campuuid", campuuid);
        params.put("install_time", String.valueOf(System.currentTimeMillis()));
        params.put("event_name", eventType);
        params.put("gaid", queryParams.getFirst((Object)"gaid"));
        url = OkHttpUtils.appendParams((String)url, (Map)params);
        return new HttpGet(url);
    }

    @Override
    public Rtb rtb() {
        return Rtb.MintegralOverseas;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return (FeedbackResponse)JsonHelper.convert((String)body, Response.class);
    }

    private static class Response
    extends FeedbackResponse {
        private String error;
        private String success;

        @Override
        public boolean isSuccess() {
            return StringUtils.equals((String)"0", (String)this.error);
        }

        public String getError() {
            return this.error;
        }

        public String getSuccess() {
            return this.success;
        }

        public void setError(String error) {
            this.error = error;
        }

        public void setSuccess(String success) {
            this.success = success;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$error = this.getError();
            String other$error = other.getError();
            if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
                return false;
            }
            String this$success = this.getSuccess();
            String other$success = other.getSuccess();
            return !(this$success == null ? other$success != null : !this$success.equals(other$success));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            String $success = this.getSuccess();
            result = result * 59 + ($success == null ? 43 : $success.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MintegralOverseasRtbIntegration.Response(error=" + this.getError() + ", success=" + this.getSuccess() + ")";
        }
    }
}

