/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.qimaoOcpx;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.integration.utils.HttpClientUtils;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.RtbConfig;
import com.bxm.adscounter.rtb.common.impl.qimaoOcpx.QiMaoOcpxConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class QiMaoOcpxIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(QiMaoOcpxIntegration.class);

    public QiMaoOcpxIntegration(QiMaoOcpxConfig config) {
        super(config, QiMaoOcpxIntegration.createHttpClient(config));
    }

    public static HttpClient createHttpClient(RtbConfig config) {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContexts.custom().setProtocol("TLSv1.2").build();
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
        }
        return HttpClientUtils.createHttpClient((int)config.getMaxTotal(), (int)config.getDefaultMaxPerRoute(), (int)config.getConnectionRequestTimeout(), (int)config.getConnectTimeout(), (int)config.getSocketTimeout(), (SSLContext)sslContext);
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String eventType = request.getEventType();
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String callback = (String)keyValueMap.getFirst((Object)"click_id");
        if (StringUtils.isBlank((String)callback)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, String.format("Cannot found callback from keyValueMap. keyValueMap: %s", JSONObject.toJSONString((Object)keyValueMap)));
        }
        String callbackUrl = UriComponentsBuilder.fromUriString((String)UrlHelper.urlDecode((String)callback)).replaceQueryParam("event_type", new Object[]{eventType}).replaceQueryParam("timestamp", new Object[]{System.currentTimeMillis()}).build().toString();
        return new HttpGet(callbackUrl);
    }

    @Override
    public Rtb rtb() {
        return Rtb.QiMaoOcpx;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return (FeedbackResponse)JsonHelper.convert((String)body, QiMaoResponse.class);
    }

    private static class QiMaoResponse
    extends FeedbackResponse {
        private int code = -1;
        private String message;

        private QiMaoResponse() {
        }

        @Override
        public boolean isSuccess() {
            return this.code == 0;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

