/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.sigmobdsp;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.sigmobdsp.SigmobDspConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.UrlHelper;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class SigmobDspRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(SigmobDspRtbIntegration.class);
    private static final String CALLBACK = "callback";

    public SigmobDspRtbIntegration(SigmobDspConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.SigmobDsp;
    }

    @Override
    protected List<Integer> successHttpCode() {
        return Lists.newArrayList((Object[])new Integer[]{200, 204});
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return false;
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "click_id";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String mt = keyValueMap.getMt();
        boolean isCallBackApi = Objects.equals(CALLBACK, eventType);
        MultiValueMap queryParams = UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams();
        String callback = (String)queryParams.getFirst((Object)"get_callback");
        String clickIdParameterNameOnReferrer = this.getClickIdParameterNameOnReferrer();
        String clickId = (String)queryParams.getFirst((Object)clickIdParameterNameOnReferrer);
        if (isCallBackApi) {
            if (StringUtils.isBlank((String)callback)) {
                throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'get_callback' by referrer.");
            }
            String url = UrlHelper.urlDecode((String)callback);
            return new HttpGet(url);
        }
        if (StringUtils.isBlank((String)eventType)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'eventType'.");
        }
        if (StringUtils.isBlank((String)clickId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found '" + clickIdParameterNameOnReferrer + "'.");
        }
        String url = UriComponentsBuilder.fromUriString((String)this.config.getUrl()).replaceQueryParam("_uniq_key", new Object[]{"sig_active"}).replaceQueryParam("_ac_type", new Object[]{"80"}).replaceQueryParam("_user_id", new Object[]{"0"}).replaceQueryParam("platform", new Object[]{"0"}).replaceQueryParam("e", new Object[]{eventType}).replaceQueryParam("clickid", new Object[]{clickId}).replaceQueryParam("event_time", new Object[]{System.currentTimeMillis() / 1000L}).replaceQueryParam("currency_type", new Object[]{"CNY"}).replaceQueryParam("currency_amount", new Object[]{"0"}).toUriString();
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }
}

