/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.tencent;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.tencent.TencentConfig;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.UrlHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class TencentRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(TencentRtbIntegration.class);
    public static final String CLICK_ID = "qz_gdt";
    private final TencentConfig config;

    public TencentRtbIntegration(TencentConfig config) {
        super(config);
        this.config = config;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String referrer = request.getReferrer();
        UriComponents build = UriComponentsBuilder.fromUriString((String)referrer).build();
        MultiValueMap queryParams = build.getQueryParams();
        String clickId = (String)queryParams.getFirst((Object)CLICK_ID);
        KeyValueMap clickTracker = this.getClickTracker(clickId);
        return Optional.ofNullable(clickTracker).map(k -> (String)k.getFirst((Object)"ad_group_id")).orElse("");
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        String tencentLinkCfg = request.getConfig().getCustomerId();
        String tencentLink = StringUtils.isNotBlank((String)tencentLinkCfg) ? tencentLinkCfg : this.config.getTencentLink();
        String clickid = (String)UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams().getFirst((Object)CLICK_ID);
        if (StringUtils.isBlank((String)clickid)) {
            clickid = (String)UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams().getFirst((Object)"gdt_vid");
        }
        if (StringUtils.isEmpty((String)clickid)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'clickid' by referrer.");
        }
        HashMap params = Maps.newHashMap();
        params.put("clickid", clickid);
        params.put("action_type", eventType);
        params.put("action_time", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("link", tencentLink);
        PositionRtb config = request.getConfig();
        String payAmount = (String)request.getKeyValueMap().getFirst((Object)"pay_amount");
        if ((StringUtils.equals((String)config.getTargetOneRtb(), (String)"PURCHASE") || StringUtils.equals((String)config.getTargetTwoRtb(), (String)"PURCHASE")) && StringUtils.isNotBlank((String)payAmount)) {
            Float aFloat = Float.valueOf(payAmount);
            Float value = Float.valueOf(aFloat.floatValue() * 100.0f);
            ActionParam build = ActionParam.builder().value(value.intValue()).build();
            params.put("action_param", JSONObject.toJSONString((Object)build));
        }
        url = OkHttpUtils.appendParams((String)url, (Map)params);
        return new HttpGet(url);
    }

    @Override
    public Rtb rtb() {
        return Rtb.GuangDianTong;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }

    private static class ActionParam {
        private Integer value;

        ActionParam(Integer value) {
            this.value = value;
        }

        public static ActionParamBuilder builder() {
            return new ActionParamBuilder();
        }

        public Integer getValue() {
            return this.value;
        }

        public void setValue(Integer value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ActionParam)) {
                return false;
            }
            ActionParam other = (ActionParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$value = this.getValue();
            Integer other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ActionParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        public String toString() {
            return "TencentRtbIntegration.ActionParam(value=" + this.getValue() + ")";
        }

        public static class ActionParamBuilder {
            private Integer value;

            ActionParamBuilder() {
            }

            public ActionParamBuilder value(Integer value) {
                this.value = value;
                return this;
            }

            public ActionParam build() {
                return new ActionParam(this.value);
            }

            public String toString() {
                return "TencentRtbIntegration.ActionParam.ActionParamBuilder(value=" + this.value + ")";
            }
        }
    }
}

