/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.vivo;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.vivo.VivoConfig;
import com.bxm.adscounter.rtb.common.impl.vivo.VivoRequest;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UUIDHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class VivoRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(VivoRtbIntegration.class);
    public static final String CLICK_ID = "requestid";
    public static final String NAME_VIVO_SRC_TYPE = "vivo_src_type";
    public static final String SRC_TYPE_WEB = "Web";
    public static final String SRC_TYPE_APP = "APP";

    public VivoRtbIntegration(VivoConfig config) {
        super(config);
    }

    @Override
    public Rtb rtb() {
        return Rtb.Vivo;
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return true;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String referrer = request.getReferrer();
        UriComponents build = UriComponentsBuilder.fromUriString((String)referrer).build();
        MultiValueMap queryParams = build.getQueryParams();
        String clickId = (String)queryParams.getFirst((Object)CLICK_ID);
        KeyValueMap clickTracker = this.getClickTracker(clickId);
        return Optional.ofNullable(clickTracker).map(k -> (String)k.getFirst((Object)"ad_group_id")).orElse("");
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        PositionRtb config = request.getConfig();
        String vivoSrcId = config.getSourceId();
        String accessToken = config.getToken();
        String vivoAdvertiserId = Optional.ofNullable(config.getCustomerId()).orElse("");
        LinkedMultiValueMap queryParams = StringUtils.isBlank((String)referrer) ? new LinkedMultiValueMap() : UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams();
        String requestId = request.getClickId();
        requestId = StringUtils.isNotBlank((String)requestId) ? requestId : (String)queryParams.getFirst((Object)CLICK_ID);
        requestId = StringUtils.isNotBlank((String)requestId) ? requestId : (String)queryParams.getFirst((Object)"requestId");
        String creativeId = (String)queryParams.getFirst((Object)"adid");
        creativeId = StringUtils.isNotBlank((String)creativeId) ? creativeId : (String)queryParams.getFirst((Object)"creativeId");
        String string = creativeId = StringUtils.isNotBlank((String)creativeId) ? creativeId : (String)keyValueMap.getFirst((Object)"creativeid");
        if (StringUtils.isBlank((String)vivoSrcId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'vivoSrcId'.");
        }
        if (StringUtils.isBlank((String)accessToken)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'accessToken'.");
        }
        if (StringUtils.isBlank((String)requestId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'requestId' or 'requestid' by referrer.");
        }
        if (StringUtils.isBlank((String)creativeId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'creativeId' or 'adid' by referrer.");
        }
        if (StringUtils.isBlank((String)eventType)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'eventType'.");
        }
        String srcType = StringUtils.defaultIfBlank((String)((String)keyValueMap.getFirst((Object)NAME_VIVO_SRC_TYPE)), (String)SRC_TYPE_WEB);
        VivoRequest.Data data = new VivoRequest.Data();
        data.setCvType(eventType);
        data.setCvTime(System.currentTimeMillis());
        data.setRequestId(requestId);
        data.setCreativeId(creativeId);
        if (StringUtils.equals((String)"PAY_ONETIME", (String)request.getEventType()) && StringUtils.isNotBlank((String)((String)keyValueMap.getFirst((Object)"pay_amount")))) {
            HashMap extParam = Maps.newHashMap();
            extParam.put("payAmount", keyValueMap.getFirst((Object)"pay_amount"));
            data.setExtParam(extParam);
        }
        VivoRequest.VivoRequestBuilder builder = VivoRequest.builder();
        if (StringUtils.equals((String)srcType, (String)SRC_TYPE_APP)) {
            builder.pkgName((String)keyValueMap.getFirst((Object)"pkgname"));
            String oaid = (String)keyValueMap.getFirst((Object)"oaid");
            String oaidMd5 = (String)keyValueMap.getFirst((Object)"oaid_md5");
            String imei = (String)keyValueMap.getFirst((Object)"imei");
            String imeiMd5 = (String)keyValueMap.getFirst((Object)"imei_md5");
            if (StringUtils.isNotBlank((String)oaid)) {
                data.setUserIdType("OAID");
                data.setUserId(oaid);
            } else if (StringUtils.isNotBlank((String)oaidMd5)) {
                data.setUserIdType("OAID_MD5");
                data.setUserId(oaidMd5);
            } else if (StringUtils.isNotBlank((String)imei)) {
                data.setUserIdType("IMEI");
                data.setUserId(imei);
            } else if (StringUtils.isNotBlank((String)imeiMd5)) {
                data.setUserIdType("IMEI_MD5");
                data.setUserId(imeiMd5);
            }
        } else {
            builder.pageUrl(referrer);
        }
        VivoRequest vivoRequest = builder.srcId(vivoSrcId).srcType(srcType).dataList(Lists.newArrayList((Object[])new VivoRequest.Data[]{data})).build();
        String entity = JsonHelper.convert((Object)vivoRequest);
        if (log.isInfoEnabled()) {
            log.info("[vivo] json body : {}", (Object)entity);
        }
        String url = this.getFeedbackUrl();
        url = UriComponentsBuilder.fromUriString((String)url).replaceQueryParam("access_token", new Object[]{accessToken}).replaceQueryParam("timestamp", new Object[]{System.currentTimeMillis()}).replaceQueryParam("nonce", new Object[]{UUIDHelper.generate()}).replaceQueryParam("advertiser_id", new Object[]{vivoAdvertiserId}).toUriString();
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new StringEntity(entity, StandardCharsets.UTF_8));
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        request.setRequestBody(entity);
        return post;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        VivoResponse response = (VivoResponse)JsonHelper.convert((String)body, VivoResponse.class);
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(response.isSuccess());
        feedbackResponse.setBody(response.getMessage());
        return feedbackResponse;
    }

    @Override
    public String[] getMissingAdGroupIdList() {
        return new String[]{"__CREATIVEID__", "NULL"};
    }

    private static class VivoResponse {
        private String code;
        private String message;

        public boolean isSuccess() {
            return StringUtils.equalsIgnoreCase((String)"0", (String)this.code);
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VivoResponse)) {
                return false;
            }
            VivoResponse other = (VivoResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VivoResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "VivoRtbIntegration.VivoResponse(code=" + this.getCode() + ", message=" + this.getMessage() + ")";
        }
    }
}

