/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.weibodownload;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.weibodownload.WeiBoDownloadConfig;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeiBoDownloadRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(WeiBoDownloadRtbIntegration.class);
    private static final int EXPIRE_TIME_SECOND = 86400;
    private Updater updater;
    private Fetcher fetcher;

    public WeiBoDownloadRtbIntegration(WeiBoDownloadConfig config) {
        super(config, (HttpClient)WeiBoDownloadRtbIntegration.createHttpClient());
    }

    private static CloseableHttpClient createHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(4000).setConnectionRequestTimeout(1000).setConnectTimeout(1000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }

    @Override
    public void saveClickTracker(KeyValueMap clickTrackerKeyValueMap) {
        String idfaMd5 = (String)clickTrackerKeyValueMap.getFirst((Object)"idfa_md5");
        String imeiMd5 = (String)clickTrackerKeyValueMap.getFirst((Object)"imei_md5");
        String oaidMd5 = (String)clickTrackerKeyValueMap.getFirst((Object)"oaid_md5");
        String androididMd5 = (String)clickTrackerKeyValueMap.getFirst((Object)"androidid_md5");
        String ip = (String)clickTrackerKeyValueMap.getFirst((Object)"ip");
        String ua = (String)clickTrackerKeyValueMap.getFirst((Object)"ua");
        if (StringUtils.isNotBlank((String)idfaMd5)) {
            this.updater.update(this.createKey(idfaMd5), (Object)clickTrackerKeyValueMap, 86400);
        }
        if (StringUtils.isNotBlank((String)imeiMd5)) {
            this.updater.update(this.createKey(imeiMd5), (Object)clickTrackerKeyValueMap, 86400);
        }
        if (StringUtils.isNotBlank((String)oaidMd5)) {
            this.updater.update(this.createKey(oaidMd5), (Object)clickTrackerKeyValueMap, 86400);
        }
        if (StringUtils.isNotBlank((String)androididMd5)) {
            this.updater.update(this.createKey(androididMd5), (Object)clickTrackerKeyValueMap, 86400);
        }
        if (StringUtils.isNotBlank((String)ip) && StringUtils.isNotBlank((String)ua)) {
            this.updater.update(this.createKey(ip + ua), (Object)clickTrackerKeyValueMap, 86400);
        }
    }

    @Override
    public KeyValueMap getClickTracker(String clickId) {
        return (KeyValueMap)this.fetcher.fetch(this.createKey(clickId), KeyValueMap.class);
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        PositionRtb config = request.getConfig();
        String company = config.getCustomerId();
        if (StringUtils.isBlank((String)company)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "company:Configuration cannot be empty");
        }
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String idfaMd5 = (String)keyValueMap.getFirst((Object)"idfa_md5");
        String imeiMd5 = (String)keyValueMap.getFirst((Object)"imei_md5");
        String oaidMd5 = (String)keyValueMap.getFirst((Object)"oaid_md5");
        String androididMd5 = (String)keyValueMap.getFirst((Object)"androidid_md5");
        String ip = (String)keyValueMap.getFirst((Object)"ip");
        String ua = (String)keyValueMap.getFirst((Object)"ua");
        KeyValueMap clickTracker = null;
        boolean isAvailableDevice = true;
        if (StringUtils.isNotBlank((String)idfaMd5)) {
            clickTracker = this.getClickTracker(idfaMd5);
            isAvailableDevice = false;
        }
        if (StringUtils.isNotBlank((String)imeiMd5)) {
            clickTracker = this.getClickTracker(imeiMd5);
            isAvailableDevice = false;
        }
        if (StringUtils.isNotBlank((String)oaidMd5)) {
            clickTracker = this.getClickTracker(oaidMd5);
            isAvailableDevice = false;
        }
        if (StringUtils.isNotBlank((String)androididMd5)) {
            clickTracker = this.getClickTracker(androididMd5);
            isAvailableDevice = false;
        }
        if (StringUtils.isNotBlank((String)ip) && StringUtils.isNotBlank((String)ua)) {
            clickTracker = this.getClickTracker(ip + ua);
            isAvailableDevice = false;
        }
        if (isAvailableDevice) {
            throw new RtbIntegrationException(FailType.NotFoundClickId, "No device number available!");
        }
        if (Objects.isNull(clickTracker)) {
            throw new RtbIntegrationException(FailType.NotFoundClickId, "Click monitoring parameters cannot be found!");
        }
        String imp = (String)clickTracker.getFirst((Object)"IMP");
        if (StringUtils.isBlank((String)imp)) {
            throw new RtbIntegrationException(FailType.NotFoundClickId, "Click monitoring parameters IMP cannot be found!");
        }
        String url = this.getFeedbackUrl();
        HashMap params = Maps.newHashMap();
        params.put("company", company);
        params.put("action_type", request.getEventType());
        params.put("IMP", imp);
        if (StringUtils.isNotBlank((String)imeiMd5)) {
            params.put("imei", imeiMd5);
        }
        if (StringUtils.isNotBlank((String)oaidMd5)) {
            params.put("oaid", oaidMd5);
        }
        if (StringUtils.isNotBlank((String)idfaMd5)) {
            params.put("idfa", idfaMd5);
        }
        if (StringUtils.isNotBlank((String)ip) && StringUtils.isNotBlank((String)ua)) {
            params.put("ip", ip);
            params.put("ua", ua);
        }
        if (StringUtils.isNotBlank((String)((String)clickTracker.getFirst((Object)"MODEL")))) {
            params.put("model", clickTracker.getFirst((Object)"MODEL"));
        }
        if (StringUtils.isNotBlank((String)((String)clickTracker.getFirst((Object)"LANGUAGE")))) {
            params.put("language", clickTracker.getFirst((Object)"LANGUAGE"));
        }
        if (StringUtils.isNotBlank((String)((String)clickTracker.getFirst((Object)"GX_CAID")))) {
            params.put("GX_CAID", clickTracker.getFirst((Object)"GX_CAID"));
        }
        url = OkHttpUtils.appendParams((String)url, (Map)params);
        log.info("\u5fae\u535a\u5e94\u7528\u4e0b\u8f7d\u56de\u4f20url\uff1a{}", (Object)url);
        HttpGet httpGet = new HttpGet(url);
        return httpGet;
    }

    @Override
    public Rtb rtb() {
        return Rtb.WEIBODOWNLOAD;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }
}

