/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.wifiocpx;

import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.wifiocpx.WifiOcpxConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.http.OkHttpUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WifiOcpxRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(WifiOcpxRtbIntegration.class);
    private final WifiOcpxConfig config;

    public WifiOcpxRtbIntegration(WifiOcpxConfig config) {
        super(config);
        this.config = config;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        KeyValueMap keyValueMap = request.getKeyValueMap();
        HashMap<String, Object> params = new HashMap<String, Object>(15);
        params.put("cid", keyValueMap.getFirst((Object)"cid"));
        params.put("sid", keyValueMap.getFirst((Object)"sid"));
        params.put("stime", keyValueMap.getFirst((Object)"sid"));
        params.put("os", keyValueMap.getFirst((Object)"os"));
        params.put("idfa", keyValueMap.getFirst((Object)"idfa"));
        params.put("mac", keyValueMap.getFirst((Object)"mac"));
        params.put("imei", keyValueMap.getFirst((Object)"imei"));
        params.put("clientid", this.config.getClientId());
        params.put("event_type", request.getEventType());
        params.put("ts", System.currentTimeMillis());
        params.put("sign", this.getSign(params, this.config.getSecretKey()));
        url = OkHttpUtils.appendParams((String)url, params);
        return new HttpGet(url);
    }

    private String getSign(Map<String, Object> params, String token) {
        TreeMap<String, Object> sortParams = new TreeMap<String, Object>(params);
        Set set = sortParams.entrySet();
        StringBuilder valueSb = new StringBuilder();
        for (Map.Entry entry : set) {
            valueSb.append((String)entry.getKey()).append("=").append((Object)(Objects.isNull(entry.getValue()) ? "" : entry.getValue())).append("&");
        }
        String value = valueSb.toString().substring(0, valueSb.toString().length() - 1) + token;
        return DigestUtils.md5Hex((String)value).toUpperCase();
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }

    @Override
    public Rtb rtb() {
        return Rtb.WifiOcpx;
    }
}

