/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.xiaomi;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.xiaomi.XiaomiConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.UrlHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class XiaomiRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(XiaomiRtbIntegration.class);
    public static final String CLICK_ID = "logExtra";

    public XiaomiRtbIntegration(XiaomiConfig config) {
        super(config, (HttpClient)XiaomiRtbIntegration.createHttpClient());
    }

    @Override
    public Rtb rtb() {
        return Rtb.XiaoMi;
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return false;
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        return UrlHelper.getFirstValueOfParamName((String)clickEventLog.getRef(), (String)CLICK_ID);
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String referrer = request.getReferrer();
        UriComponents build = UriComponentsBuilder.fromUriString((String)referrer).build();
        MultiValueMap queryParams = build.getQueryParams();
        String clickId = (String)queryParams.getFirst((Object)CLICK_ID);
        KeyValueMap clickTracker = this.getClickTracker(clickId);
        return Optional.ofNullable(clickTracker).map(k -> (String)k.getFirst((Object)"ad_group_id")).orElse("");
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        MultiValueMap queryParams = UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams();
        String conversionId = (String)queryParams.getFirst((Object)"conversionId");
        String logExtra = (String)queryParams.getFirst((Object)CLICK_ID);
        String webConversionId = (String)queryParams.getFirst((Object)"webConversionId");
        String conversion_debug = (String)queryParams.getFirst((Object)"conversion_debug");
        if (StringUtils.isBlank((String)conversionId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'conversionId' by referrer.");
        }
        if (StringUtils.isBlank((String)logExtra)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'logExtra' by referrer.");
        }
        if (StringUtils.isBlank((String)webConversionId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'webConversionId' by referrer.");
        }
        HashMap params = Maps.newHashMap();
        params.put("conversionId", conversionId);
        params.put("eventType", "form");
        params.put("clientTime", String.valueOf(System.currentTimeMillis()));
        params.put(CLICK_ID, logExtra);
        params.put("webConversionId", webConversionId);
        params.put("convType", eventType);
        if (StringUtils.isNotBlank((String)conversion_debug) && Objects.equals(conversion_debug, "true")) {
            params.put("conversion_debug", conversion_debug);
        }
        url = OkHttpUtils.appendParams((String)url, (Map)params);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        feedbackResponse.setSuccess(true);
        return feedbackResponse;
    }

    private static CloseableHttpClient createHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(2000).setConnectionRequestTimeout(1000).setConnectTimeout(1000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }
}

