/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.xiaomiocpx;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.xiaomiocpx.XiaomiOcpxConfig;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XiaomiOcpxRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(XiaomiOcpxRtbIntegration.class);

    public XiaomiOcpxRtbIntegration(XiaomiOcpxConfig config) {
        super(config, (HttpClient)XiaomiOcpxRtbIntegration.createHttpClient());
    }

    @Override
    public Rtb rtb() {
        return Rtb.XiaoMiOcpx;
    }

    @Override
    protected boolean isReadBodyForHttpResponse() {
        return true;
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String eventType = request.getEventType();
        String callback = request.getClickId();
        if (StringUtils.isBlank((String)eventType)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'eventType'.");
        }
        if (StringUtils.isBlank((String)callback)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, "Cannot found 'callback'.");
        }
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String imei = (String)keyValueMap.getFirst((Object)"imei");
        String oaid = (String)keyValueMap.getFirst((Object)"oaid");
        HashMap params = Maps.newHashMap();
        params.put("callback", callback);
        params.put("conv_time", String.valueOf(System.currentTimeMillis()));
        params.put("convType", eventType);
        if (StringUtils.isNotBlank((String)imei)) {
            params.put("imei", imei);
        } else {
            params.put("oaid", oaid);
        }
        url = OkHttpUtils.appendParams((String)url, (Map)params);
        return new HttpGet(url);
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) throws RtbIntegrationException {
        Response response = (Response)JsonHelper.convert((String)body, Response.class);
        FeedbackResponse feedbackResponse = new FeedbackResponse();
        if (Objects.nonNull(response)) {
            feedbackResponse.setSuccess(response.getSuccess());
            feedbackResponse.setBody(response.getFailMsg());
        } else {
            feedbackResponse.setSuccess(false);
        }
        return feedbackResponse;
    }

    private static CloseableHttpClient createHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(2000).setConnectionRequestTimeout(1000).setConnectTimeout(1000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }

    public static class Response {
        private String code;
        private String failMsg;
        private Boolean success;

        public String getCode() {
            return this.code;
        }

        public String getFailMsg() {
            return this.failMsg;
        }

        public Boolean getSuccess() {
            return this.success;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setFailMsg(String failMsg) {
            this.failMsg = failMsg;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$success = this.getSuccess();
            Boolean other$success = other.getSuccess();
            if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$failMsg = this.getFailMsg();
            String other$failMsg = other.getFailMsg();
            return !(this$failMsg == null ? other$failMsg != null : !this$failMsg.equals(other$failMsg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $success = this.getSuccess();
            result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $failMsg = this.getFailMsg();
            result = result * 59 + ($failMsg == null ? 43 : $failMsg.hashCode());
            return result;
        }

        public String toString() {
            return "XiaomiOcpxRtbIntegration.Response(code=" + this.getCode() + ", failMsg=" + this.getFailMsg() + ", success=" + this.getSuccess() + ")";
        }
    }
}

