/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.xunfei;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.xunfei.XunFeiConfig;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.utils.JsonHelper;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class XunFeiRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(XunFeiRtbIntegration.class);
    private final XunFeiConfig config;

    public XunFeiRtbIntegration(XunFeiConfig config) {
        super(config);
        this.config = config;
    }

    @Override
    public String getClickIdParameterNameOnReferrer() {
        return "requestId";
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String url = this.getFeedbackUrl();
        String referrer = request.getReferrer();
        String eventType = request.getEventType();
        PositionRtb positionRtb = request.getConfig();
        String clickIdParameterNameOnReferrer = this.getClickIdParameterNameOnReferrer();
        String requestId = (String)UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams().getFirst((Object)clickIdParameterNameOnReferrer);
        if (StringUtils.isBlank((String)requestId)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, positionRtb.getPositionId() + "Cannot found '" + clickIdParameterNameOnReferrer + "' by referrer.");
        }
        String creativeId = (String)UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams().getFirst((Object)"creativeId");
        Data data = new Data();
        data.setCvTime(System.currentTimeMillis());
        data.setCvType(eventType);
        data.setRequestId(requestId);
        data.setCreativeId(creativeId);
        XunFeiRequest xunFeiRequest = new XunFeiRequest();
        xunFeiRequest.setSrcId(positionRtb.getSourceId());
        xunFeiRequest.setSrcType("Web");
        xunFeiRequest.setData(data);
        String entity = JsonHelper.convert((Object)xunFeiRequest);
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new StringEntity(entity, StandardCharsets.UTF_8));
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        request.setRequestBody(entity);
        return post;
    }

    @Override
    public Rtb rtb() {
        return Rtb.XunFei;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        FeedbackResponse feedbackResponse = (FeedbackResponse)JsonHelper.convert((String)body, Response.class);
        return feedbackResponse;
    }

    private static class Data {
        private String cvType;
        private Long cvTime;
        private String requestId;
        private String creativeId;

        private Data() {
        }

        public String getCvType() {
            return this.cvType;
        }

        public void setCvType(String cvType) {
            this.cvType = cvType;
        }

        public Long getCvTime() {
            return this.cvTime;
        }

        public void setCvTime(Long cvTime) {
            this.cvTime = cvTime;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public String getCreativeId() {
            return this.creativeId;
        }

        public void setCreativeId(String creativeId) {
            this.creativeId = creativeId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }
    }

    private static class XunFeiRequest {
        private String srcType;
        private Data data;
        private String srcId;

        private XunFeiRequest() {
        }

        public String getSrcType() {
            return this.srcType;
        }

        public void setSrcType(String srcType) {
            this.srcType = srcType;
        }

        public Data getData() {
            return this.data;
        }

        public void setData(Data data) {
            this.data = data;
        }

        public String getSrcId() {
            return this.srcId;
        }

        public void setSrcId(String srcId) {
            this.srcId = srcId;
        }
    }

    private static class Response
    extends FeedbackResponse {
        private Integer code;
        private String message;

        private Response() {
        }

        @Override
        public boolean isSuccess() {
            return this.code == 200;
        }

        public Integer getCode() {
            return this.code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

