/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.impl.yixiao;

import com.bxm.adscounter.rtb.common.FailType;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.impl.AbstractClickTrackerRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.yixiao.YiXiaoConfig;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class YiXiaoRtbIntegration
extends AbstractClickTrackerRtbIntegration {
    private static final Logger log = LoggerFactory.getLogger(YiXiaoRtbIntegration.class);
    public static final String CLICK_ID = "callback";

    public YiXiaoRtbIntegration(YiXiaoConfig config) {
        super(config);
    }

    @Override
    public String getClickId(KeyValueMap clickTrackerKeyValueMap) {
        return (String)clickTrackerKeyValueMap.getFirst((Object)"click_id");
    }

    @Override
    public String getClickIdOnInadsAdClickLog(KeyValueMap clickEventLog) {
        String ref = clickEventLog.getRef();
        String clickId = UrlHelper.getFirstValueOfParamName((String)ref, (String)CLICK_ID);
        if (StringUtils.isBlank((String)clickId)) {
            log.warn("Not found: {}", (Object)ref);
            return null;
        }
        return DigestUtils.md5Hex((String)UrlHelper.urlDecode((String)clickId));
    }

    @Override
    public String getAdGroupId(FeedbackRequest request) {
        String clickId = UrlHelper.getFirstValueOfParamName((String)request.getReferrer(), (String)CLICK_ID);
        KeyValueMap clickTracker = this.getClickTracker(DigestUtils.md5Hex((String)UrlHelper.urlDecode((String)clickId)));
        return Optional.ofNullable(clickTracker).map(k -> (String)k.getFirst((Object)"ad_group_id")).orElse("");
    }

    @Override
    protected HttpRequestBase create(FeedbackRequest request) throws RtbIntegrationException {
        String referrer = request.getReferrer();
        PositionRtb positionRtb = request.getConfig();
        String eventType = request.getEventType();
        String callback = (String)UriComponentsBuilder.fromUriString((String)referrer).build().getQueryParams().getFirst((Object)CLICK_ID);
        if (StringUtils.isBlank((String)callback)) {
            throw new RtbIntegrationException(FailType.IllegalParameter, positionRtb.getPositionId() + "\uff1a Cannot found 'callback' by referrer.");
        }
        String url = UrlHelper.urlDecode((String)callback) + "&conv_type=" + eventType + "&t=" + System.currentTimeMillis();
        return new HttpGet(url);
    }

    @Override
    public Rtb rtb() {
        return Rtb.YiXiao;
    }

    @Override
    protected FeedbackResponse convert(FeedbackRequest request, String body) {
        return (FeedbackResponse)JsonHelper.convert((String)body, Response.class);
    }

    private static class Response
    extends FeedbackResponse {
        private String status;
        private String msg;

        private Response() {
        }

        @Override
        public boolean isSuccess() {
            return StringUtils.equalsIgnoreCase((String)"SUCCESSED", (String)this.status);
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }
}

