/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.listener;

import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbProperties;
import com.bxm.adscounter.rtb.common.event.RtbDeductionEvent;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.UrlHelper;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtbDeductionEventListener
implements EventListener<RtbDeductionEvent> {
    private static final Logger log = LoggerFactory.getLogger(RtbDeductionEventListener.class);
    private final RtbProperties properties;
    private final OpenLogClient openLogClient;

    public RtbDeductionEventListener(RtbProperties properties, OpenLogClient openLogClient) {
        this.properties = properties;
        this.openLogClient = openLogClient;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(RtbDeductionEvent event) {
        Rtb rtb = event.getRtb();
        FeedbackRequest request = event.getRequest();
        String deductionType = Optional.ofNullable(event.getDeductionType()).orElse(RtbDeductionEvent.DEDUCTION).toString();
        if (Objects.isNull((Object)rtb) || Objects.isNull(request)) {
            return;
        }
        this.sendOpenLog(rtb, request, deductionType);
    }

    private void sendOpenLog(Rtb rtb, FeedbackRequest request, String deductionType) {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        KeyValueMap map = new KeyValueMap();
        map.put("p", Production.COMMON.getName());
        map.put("mt", Common.Mt.rtbDeduction.original());
        map.put("bxmid", (String)keyValueMap.getFirst((Object)"bxmid"));
        map.put("type", (String)keyValueMap.getFirst((Object)"conversion_type"));
        map.put("uid", (String)keyValueMap.getFirst((Object)"uid"));
        map.put("time", (Object)System.currentTimeMillis());
        map.put("adid", (String)keyValueMap.getFirst((Object)"adid"));
        map.put("tagid", (String)keyValueMap.getFirst((Object)"tagid"));
        map.put("createid", (String)keyValueMap.getFirst((Object)"createid"));
        map.put("ip", (String)keyValueMap.getFirst((Object)"ip"));
        map.put("ua", UrlHelper.urlEncode((String)((String)keyValueMap.getFirst((Object)"ua"))));
        map.put("rtb_id", (Object)rtb.getType());
        map.put("ad_group_id", request.getAdGroupId());
        map.putIfNotBlank("refer", UrlHelper.urlEncode((String)request.getReferrer()));
        map.putIfNotBlank("imei_md5", (String)keyValueMap.getFirst((Object)"imei_md5"));
        map.putIfNotBlank("idfa_md5", (String)keyValueMap.getFirst((Object)"idfa_md5"));
        map.putIfNotBlank("androidid_md5", (String)keyValueMap.getFirst((Object)"androidid_md5"));
        map.putIfNotBlank("oaid", (String)keyValueMap.getFirst((Object)"oaid"));
        map.putIfNotBlank("oaid_md5", (String)keyValueMap.getFirst((Object)"oaid_md5"));
        map.putIfNotBlank("deduction_type", deductionType);
        String openLogRequestUri = map.createOpenLogRequestUri(this.properties.getOpenLogRequestDomain());
        this.openLogClient.asyncRequest(openLogRequestUri);
    }
}

