/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.service;

import com.bxm.adscounter.rtb.common.ClickTracker;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.RtbIntegrationFactory;
import com.bxm.adscounter.rtb.common.control.ControlUtils;
import com.bxm.adscounter.rtb.common.control.cpa.CpaControl;
import com.bxm.adscounter.rtb.common.feedback.ActionType;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.SmartConvType;
import com.bxm.adscounter.rtb.common.service.FeedbackService;
import com.bxm.adscounter.rtb.common.service.PositionRtbService;
import com.bxm.adscounter.rtb.common.service.Updating;
import com.bxm.adscounter.rtb.common.utils.InadsExtValueUtils;
import com.bxm.adscounter.rtb.common.utils.PositionRTBUtils;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.TargetFactory;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractFeedbackService
implements FeedbackService {
    private static final Logger log = LoggerFactory.getLogger(AbstractFeedbackService.class);
    private Fetcher fetcher;
    private Counter counter;
    private RtbIntegrationFactory factory;
    private PositionRtbService service;
    private CpaControl cpaControl;
    private static final int ACTIVITY_FEEDBACK_LIMIT = 5;

    @Autowired
    public void setFetcher(Fetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Autowired
    public void setFactory(RtbIntegrationFactory factory) {
        this.factory = factory;
    }

    @Autowired
    public void setService(PositionRtbService service) {
        this.service = service;
    }

    @Autowired
    public void setCounter(Counter counter) {
        this.counter = counter;
    }

    @Autowired
    public void setCpaControl(CpaControl cpaControl) {
        this.cpaControl = cpaControl;
    }

    protected abstract boolean doFeedbackIfNecessary(PositionRtb var1);

    @Override
    public boolean doFeedback(KeyValueMap keyValueMap) throws RtbIntegrationException {
        return this.doFeedback(keyValueMap, null);
    }

    @Override
    public boolean doFeedback(KeyValueMap keyValueMap, Updating updating) throws RtbIntegrationException {
        int times;
        String bxmId = (String)keyValueMap.getFirst((Object)"bxmid");
        String positionId = (String)keyValueMap.getFirst((Object)"tagid");
        if (StringUtils.isBlank((CharSequence)positionId)) {
            log.warn("[{}] Cannot found tagid!", (Object)bxmId);
            return true;
        }
        Rtb rtb = this.getRtb();
        RtbIntegration integration = this.factory.get(rtb);
        if (Objects.isNull(integration)) {
            log.warn("Not found RtbIntegration for {}", (Object)rtb);
            return true;
        }
        PositionRtb config = this.fetchPositionRtbConfig(positionId);
        if (Objects.isNull(config)) {
            return true;
        }
        String mt = (String)keyValueMap.getFirst((Object)"mt");
        String uid = (String)keyValueMap.getFirst((Object)"uid");
        boolean isActivityAttend = StringUtils.equalsIgnoreCase((CharSequence)mt, (CharSequence)Inads.Mt.ActivityAttend.original());
        boolean isAdClick = StringUtils.equalsIgnoreCase((CharSequence)mt, (CharSequence)Inads.Mt.AdClick.original());
        boolean isAdConversion = StringUtils.equalsIgnoreCase((CharSequence)mt, (CharSequence)Inads.Mt.AdConversion.original());
        int n = times = isActivityAttend ? this.fetchActivityAttendTimes(uid) : 0;
        if (this.doFeedbackIfNecessary(config)) {
            if (isActivityAttend) {
                return this.doFeedbackOnActivityAttend(keyValueMap, updating, config, times);
            }
            if (isAdClick && this.isFeedbackIfSkipCpaOrSequenceLimit(keyValueMap, config)) {
                return this.doFeedbackOnOther(keyValueMap, NumberUtils.toInt((String)"11"), updating, config, (request, rtbIntegration) -> true);
            }
            if (isAdConversion && this.isFeedbackIfSkipCpaOrSequenceLimit(keyValueMap, config)) {
                BiFunction<FeedbackRequest, RtbIntegration, Boolean> feedbackInterceptor = (request, rtbIntegration) -> this.cpaControl.isFeedback((FeedbackRequest)request, (RtbIntegration)rtbIntegration);
                String convType = (String)keyValueMap.getFirst((Object)"conversion_type");
                int type = NumberUtils.toInt((String)convType, (int)0);
                return this.doFeedbackOnOther(keyValueMap, type, updating, config, feedbackInterceptor);
            }
        }
        return true;
    }

    private boolean isFeedbackIfSkipCpaOrSequenceLimit(KeyValueMap keyValueMap, PositionRtb config) {
        try {
            if (!config.isFeedbackModeHeadTicket()) {
                return true;
            }
            String ticketId = (String)keyValueMap.getFirst((Object)"adid");
            String positionId = (String)keyValueMap.getFirst((Object)"tagid");
            HashSet sequence = Sets.newHashSet((Iterable)Optional.ofNullable(config.getUserActSeqList()).orElse(new ArrayList()));
            Integer maxCpaLimit = config.getCpa();
            String rank = AbstractFeedbackService.getAcquiredRankByActivity(keyValueMap);
            if (StringUtils.isNotBlank((CharSequence)rank) && CollectionUtils.isNotEmpty((Collection)sequence) && !sequence.contains(rank)) {
                return false;
            }
            if (Objects.isNull(maxCpaLimit)) {
                return true;
            }
            if (PositionRTBUtils.isHeadTicket(ticketId, config)) {
                return true;
            }
            Integer configCpaPrice = this.getConfigCpaPrice(positionId, ticketId);
            if (Objects.isNull(configCpaPrice)) {
                return true;
            }
            return configCpaPrice > maxCpaLimit;
        }
        catch (Exception e) {
            log.error("isFeedbackIfSkipCpaOrSequenceLimit: ", (Throwable)e);
            return true;
        }
    }

    private Integer getConfigCpaPrice(String positionId, String ticketId) {
        Integer price = (Integer)this.fetcher.hfetch(new TargetFactory().keyGenerator(TicketKeyGenerator.getTicketRTBCPAPrice((String)ticketId)).field(positionId).skipNativeCache(true).cls(Integer.class).build());
        if (Objects.nonNull(price)) {
            return price;
        }
        price = (Integer)this.fetcher.hfetch(new TargetFactory().keyGenerator(TicketKeyGenerator.getTicketRTBCPAPrice((String)ticketId)).field(ticketId).skipNativeCache(true).cls(Integer.class).build());
        return price;
    }

    private boolean doFeedbackOnActivityAttend(KeyValueMap keyValueMap, Updating updating, PositionRtb config, int times) throws RtbIntegrationException {
        boolean allowFeedbackDeep;
        String targetOneRtb = config.getTargetOneRtb();
        String targetTwoRtb = config.getTargetTwoRtb();
        String activityOne = config.getActivityOne();
        String activityTwo = config.getActivityTwo();
        String shallowKey = ControlUtils.createKey(config.getPositionId(), "shallow");
        String deepKey = ControlUtils.createKey(config.getPositionId(), "deep");
        boolean allowFeedbackShallow = this.fetchActivityFeedbackTimes(shallowKey) < 5;
        boolean bl = allowFeedbackDeep = this.fetchActivityFeedbackTimes(deepKey) < 5;
        if (StringUtils.equals((CharSequence)activityOne, (CharSequence)"1")) {
            if (config.isEnableActivityFeedbackLimitShallow()) {
                if (allowFeedbackShallow) {
                    boolean feedbackSuccess = this.doFeedback0(keyValueMap, updating, config, targetOneRtb, 1, "1");
                    if (feedbackSuccess) {
                        this.counter.incrementAndGet(AbstractFeedbackService.stringActivityFeedbackTimes(shallowKey));
                    }
                    return feedbackSuccess;
                }
            } else {
                return this.doFeedback0(keyValueMap, updating, config, targetOneRtb, 1, "1");
            }
        }
        if (StringUtils.equals((CharSequence)activityTwo, (CharSequence)"1")) {
            if (config.isEnableActivityFeedbackLimitDeep()) {
                if (allowFeedbackDeep) {
                    boolean feedbackSuccess = this.doFeedback0(keyValueMap, updating, config, targetTwoRtb, 2, "1");
                    if (feedbackSuccess) {
                        this.counter.incrementAndGet(AbstractFeedbackService.stringActivityFeedbackTimes(deepKey));
                    }
                    return feedbackSuccess;
                }
            } else {
                return this.doFeedback0(keyValueMap, updating, config, targetTwoRtb, 2, "1");
            }
        }
        if (StringUtils.equals((CharSequence)activityOne, (CharSequence)"2") || StringUtils.equals((CharSequence)activityTwo, (CharSequence)"2")) {
            if (StringUtils.equals((CharSequence)activityOne, (CharSequence)"2") && times == 2) {
                return this.doFeedback0(keyValueMap, updating, config, targetOneRtb, 1, "2");
            }
            if (StringUtils.equals((CharSequence)activityTwo, (CharSequence)"2") && times == 2) {
                return this.doFeedback0(keyValueMap, updating, config, targetTwoRtb, 2, "2");
            }
        }
        return true;
    }

    private boolean doFeedbackOnOther(KeyValueMap keyValueMap, int type, Updating updating, PositionRtb config, BiFunction<FeedbackRequest, RtbIntegration, Boolean> feedbackInterceptor) throws RtbIntegrationException {
        String adid = (String)keyValueMap.getFirst((Object)"adid");
        String targetOneRtb = config.getTargetOneRtb();
        String targetTwoRtb = config.getTargetTwoRtb();
        if (config.isFeedbackModeSummaryCpa()) {
            if (PositionRTBUtils.isAdClick(type) || Objects.isNull(targetOneRtb)) {
                return true;
            }
            return this.doFeedback0(keyValueMap, updating, config, targetOneRtb, 1, TypeHelper.castToString((Object)type), feedbackInterceptor);
        }
        PositionRtb.TargetBXM target = PositionRTBUtils.convert(adid, config);
        if (Objects.isNull(target)) {
            return true;
        }
        Map<String, Object> extMap = AbstractFeedbackService.getExt(keyValueMap);
        int targetOneBxm = Optional.ofNullable(target.getTargetOneBxm()).orElse(-1);
        if (targetOneBxm == NumberUtils.toInt((String)"12") && (targetOneBxm = Optional.ofNullable(TypeHelper.castToInt((Object)extMap.get("shallow_type"))).orElse(-1).intValue()) == -1) {
            log.error("[{}] bxmId Cannot found targetOneBxm ! adid: {}", keyValueMap.getFirst((Object)"bxmid"), (Object)adid);
        }
        if (type == targetOneBxm && Objects.nonNull(targetOneRtb)) {
            return this.doFeedback0(keyValueMap, updating, config, targetOneRtb, 1, TypeHelper.castToString((Object)type), feedbackInterceptor);
        }
        int targetTwoBxm = Optional.ofNullable(target.getTargetTwoBxm()).orElse(-1);
        if (targetTwoBxm == NumberUtils.toInt((String)"12") && (targetTwoBxm = Optional.ofNullable(TypeHelper.castToInt((Object)extMap.get("deep_type"))).orElse(-1).intValue()) == -1) {
            log.error("[{}] bxmId Cannot found targetTwoBxm! adid: {}", keyValueMap.getFirst((Object)"bxmid"), (Object)adid);
        }
        if (type == targetTwoBxm && Objects.nonNull(targetTwoRtb)) {
            return this.doFeedback0(keyValueMap, updating, config, targetTwoRtb, 2, TypeHelper.castToString((Object)type), feedbackInterceptor);
        }
        return true;
    }

    private boolean doFeedback0(KeyValueMap keyValueMap, Updating updating, PositionRtb config, String eventType, int conversionLevel, String conversionType) throws RtbIntegrationException {
        return this.doFeedback0(keyValueMap, updating, config, eventType, conversionLevel, conversionType, (request, integration) -> true);
    }

    private boolean doFeedback0(KeyValueMap keyValueMap, Updating updating, PositionRtb config, String eventType, int conversionLevel, String conversionType, BiFunction<FeedbackRequest, RtbIntegration, Boolean> feedbackInterceptor) throws RtbIntegrationException {
        Rtb rtb = this.getRtb();
        RtbIntegration integration = this.factory.get(rtb);
        if (Objects.isNull(integration)) {
            log.warn("Not found RtbIntegration for {}", (Object)rtb);
            return true;
        }
        FeedbackRequest request = this.createFeedbackRequest(integration, keyValueMap, updating, config, conversionLevel, conversionType, eventType);
        if (Objects.isNull(feedbackInterceptor)) {
            return integration.doFeedback(request).isSuccess();
        }
        if (feedbackInterceptor.apply(request, integration).booleanValue()) {
            return integration.doFeedback(request).isSuccess();
        }
        return true;
    }

    private FeedbackRequest createFeedbackRequest(RtbIntegration integration, KeyValueMap keyValueMap, Updating updating, PositionRtb config, int conversionLevel, String conversionType, String eventType) {
        ActionType actionType;
        String referrer = (String)keyValueMap.getFirst((Object)"refer");
        FeedbackRequest request = FeedbackRequest.builder().config(config).conversionLevel(conversionLevel).conversionType(conversionType).keyValueMap(keyValueMap).eventType(eventType).referrer(referrer).smartConvType(SmartConvType.NONE).build();
        if (Objects.nonNull(updating)) {
            updating.accept(request, config);
        }
        if (Objects.nonNull((Object)(actionType = ActionType.of(keyValueMap, config)))) {
            request.setActionType(actionType);
        }
        request.setAdGroupId(this.fetchAdGroupId(integration, request));
        return request;
    }

    private String fetchAdGroupId(RtbIntegration integration, FeedbackRequest request) {
        String adGroupId = null;
        if (integration instanceof ClickTracker) {
            ClickTracker clickTracker = (ClickTracker)((Object)integration);
            adGroupId = clickTracker.getAdGroupId(request);
            adGroupId = clickTracker.fixAdGroupIdIfInvalid(adGroupId);
        }
        return adGroupId;
    }

    private PositionRtb fetchPositionRtbConfig(String positionId) {
        return this.service.get(positionId);
    }

    private int fetchActivityAttendTimes(String uid) {
        return (Integer)Optional.ofNullable(this.fetcher.fetch(new TargetFactory().keyGenerator(PositionRTBUtils.stringActivityAttend(uid)).skipNativeCache(true).cls(Integer.class).build())).orElse(0);
    }

    private int fetchActivityFeedbackTimes(String dimensionKey) {
        return (Integer)Optional.ofNullable(this.fetcher.fetch(new TargetFactory().keyGenerator(AbstractFeedbackService.stringActivityFeedbackTimes(dimensionKey)).skipNativeCache(true).cls(Integer.class).build())).orElse(0);
    }

    public static KeyGenerator stringActivityFeedbackTimes(String dimensionKey) {
        return () -> KeyBuilder.build((Object[])new Object[]{"RTB", "ACTIVITY_LIMIT", "TIMES", dimensionKey});
    }

    public static String getAcquiredRankByActivity(KeyValueMap keyValueMap) {
        String ext = (String)keyValueMap.getFirst((Object)"ext");
        if (StringUtils.isBlank((CharSequence)ext)) {
            return null;
        }
        Map<String, Object> map = InadsExtValueUtils.parse(ext);
        return Optional.ofNullable(map).map(e -> TypeHelper.castToString(e.get("userActSeq"))).orElse(null);
    }

    public static Map<String, Object> getExt(KeyValueMap keyValueMap) {
        String ext = (String)keyValueMap.getFirst((Object)"ext");
        if (StringUtils.isBlank((CharSequence)ext)) {
            return new HashMap<String, Object>();
        }
        Map<String, Object> map = InadsExtValueUtils.parse(ext);
        return map;
    }
}

