package com.bxm.adsmanager.facade.service;

import com.bxm.adsmanager.facade.constant.Constants;
import com.bxm.adsmanager.facade.model.adTag.TblAdTagVo;
import com.bxm.warcar.utils.response.ResultModel;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author wangchao
 * @description 标签相关接口
 * @date 2019/04/09 11:06
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface AdTagFacadeService {

    @RequestMapping(value = "/adtag/newTreeAll", method = RequestMethod.GET)
    ResultModel<PageInfo<TblAdTagVo>> findNewTreeAll(@RequestParam(value = "parentId", defaultValue = "0") Integer parentId,
                                                     @RequestParam(value = "type", defaultValue = "1") Integer type,
                                                     @RequestParam(value = "name", defaultValue = "") String name,
                                                     @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                     @RequestParam(value = "pageSize", defaultValue = "20") Integer pageSize);


    @RequestMapping(value = "/adtag/newAll", method = RequestMethod.GET)
    ResultModel<PageInfo<TblAdTagVo>> findNewAll(@RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                 @RequestParam(value = "pageSize", defaultValue = "20") Integer pageSize,
                                                 @RequestParam(value = "name", defaultValue = "") String name,
                                                 @RequestParam(value = "type", defaultValue = "1") Integer type);
}
