package com.bxm.adsmanager.facade.service;

import com.bxm.adsmanager.facade.constant.Constants;
import com.bxm.adsmanager.facade.model.position.Position;
import com.bxm.adsmanager.facade.model.ticket.AdTicketCostLog;
import com.bxm.adsmanager.facade.model.ticket.TicketProfitForCpa;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author wangchao
 * @description 券相关接口
 * @date 2019/04/09 16:00
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface AdsprodTicketFacadeService {

    @RequestMapping(value = "/adsmanager/updateAdTicket", method = RequestMethod.POST,consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResultModel update(@RequestParam(required = true, name = "id") Long id,
                       @RequestParam(required = true, name = "reason") Integer reason,
                       @RequestParam(required = true, name = "status") Short status);


    @RequestMapping(value = "/adsmanager/plusAdvertiserBalance",method = RequestMethod.GET,consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResultModel<Long> plusAdvertiserBalance(@RequestParam("id") Long id, @RequestParam("value") Long value);


    @RequestMapping(value = "/adsmanager/pushCpaProfitData", method = RequestMethod.POST,consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResultModel<?> pushCpaProfitData(@RequestBody List<TicketProfitForCpa> data);

    @RequestMapping(value = "/adsmanager/pushPosition/{id}", method = RequestMethod.POST,consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResultModel<?> pushPosition(@PathVariable("id") String positionId,
                                @RequestBody Position position);

    @RequestMapping(value = "/adsmanager/addTicketCostLog", method = RequestMethod.POST,consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResultModel addTicketCostLog(@RequestBody AdTicketCostLog adTicketCostLog);

}
