package com.bxm.adsmanager.facade.service;

import com.bxm.adsmanager.facade.constant.Constants;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 监控项目修改券状态为待审核
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface AdTicketFacadeService {


    /**
     * 监控项目修改券状态为待审核
     * @param id
     * @return Boolean
     */
    @RequestMapping(value = "/adTicket/updateStatusBySentinel", method = RequestMethod.GET)
    public ResultModel<Boolean> update(@RequestParam(required = true, name = "id" ) Long id);

    /**
     * 根据券id获取ae名字
     * @param id
     * @return Boolean
     */
    @RequestMapping(value = "/adTicket/getAeCodeByTicketId", method = RequestMethod.GET)
    public ResultModel<String> getAeCodeByTicketId(@RequestParam(required = true, name = "id" ) Long id);
}
