package com.bxm.adsmanager.facade.service;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.bxm.adsmanager.facade.constant.Constants;
import com.bxm.adsmanager.facade.model.position.PositionAuditPassDataHandleDTO;
import com.bxm.warcar.utils.response.ResultModel;

/**
 * <p>
 * 广告位处理
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-10-09
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface AppEntranceFacadeService {

    /**
     * 广告位审核通过后的其他处理
     * @param dto
     * @return
     */
    @RequestMapping(value = "/adsmanager/appentrance/auditPassDataHandle", method = RequestMethod.POST)
    ResultModel<Boolean> auditPassDataHandle(@RequestBody PositionAuditPassDataHandleDTO dto);
}
