package com.bxm.adsmanager.facade.service;

import com.bxm.adsmanager.facade.constant.Constants;
import com.bxm.adsmanager.facade.model.prize.TblAdPrize;
import com.bxm.warcar.utils.response.ResultModel;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
/**
 * @author wangchao
 * @description 奖品相关接口
 * @date 2019/04/09 15:03
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface PrizeFacadeService {

    @RequestMapping(value = "/common/prize/add")
    ResultModel<Boolean> prizeInsert(@RequestParam(name = "activityId") String activityId,
                                     @RequestParam(name = "activityName") String activityName,
                                     @RequestParam(name = "prizeName") String prizeName,
                                     @RequestParam(name = "telephone") String telephone,
                                     @RequestParam(name = "token") String token);


    @RequestMapping(value = "/common/prize/find")
    ResultModel<PageInfo<TblAdPrize>> prizeFindPage(@RequestParam(name = "dateTime") String dateTime,
                                                    @RequestParam(name = "pageNum", defaultValue = "1") int pageNum,
                                                    @RequestParam(name = "pageSize", defaultValue = "10") int pageSize,
                                                    @RequestParam(name = "keyWords") String keyWords);
}
