package com.bxm.adsmanager.facade.model.position;

import java.io.Serializable;
import java.util.List;

import org.springframework.web.bind.annotation.RequestParam;

/**
 * 审核通过后的数据处理操作对象
 */
public class PositionAuditPassDataHandleDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    private FirstProviderAuditDto firstProviderAuditDto;
    private boolean isRiskController;
    private Boolean auditPass;


    public FirstProviderAuditDto getFirstProviderAuditDto() {
        return firstProviderAuditDto;
    }

    public void setFirstProviderAuditDto(FirstProviderAuditDto firstProviderAuditDto) {
        this.firstProviderAuditDto = firstProviderAuditDto;
    }

    public boolean isRiskController() {
        return isRiskController;
    }

    public void setRiskController(boolean riskController) {
        isRiskController = riskController;
    }

    public Boolean getAuditPass() {
        return auditPass;
    }

    public void setAuditPass(Boolean auditPass) {
        this.auditPass = auditPass;
    }

    public static class FirstProviderAuditDto implements Serializable {
        private static final long serialVersionUID = 1L;

        private List<Long> appEntranceSuccessIds;

        private Boolean providerFinanceStatus = false;

        private List<Long> mediaSuccessIds;

        /**
         * 兼容老数据
         */
        private Boolean result = false;

        public Boolean getProviderFinanceStatus() {
            return providerFinanceStatus;
        }

        public void setProviderFinanceStatus(Boolean providerFinanceStatus) {
            this.providerFinanceStatus = providerFinanceStatus;
        }


        public Boolean getResult() {
            return result;
        }

        public void setResult(Boolean result) {
            this.result = result;
        }

        public List<Long> getAppEntranceSuccessIds() {
            return appEntranceSuccessIds;
        }

        public void setAppEntranceSuccessIds(List<Long> appEntranceSuccessIds) {
            this.appEntranceSuccessIds = appEntranceSuccessIds;
        }

        public List<Long> getMediaSuccessIds() {
            return mediaSuccessIds;
        }

        public void setMediaSuccessIds(List<Long> mediaSuccessIds) {
            this.mediaSuccessIds = mediaSuccessIds;
        }
    }
}

