package com.bxm.adsmanager.facade.model.position;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author tangx
 * @date 2022/11/15 19:09
 */
@Data
public class PositionUpdateDto {
    @NotBlank
    private String appKey;

    /**
     * 开发者别名
     */
    @NotBlank
    private String appName;

    private String BD;

    private String MJ;

    private String remark;

    /**
     * 是否预付
     */
    @NotNull
    private Boolean prepay;

    /**
     * 账号类型 0直客， 1代理
     */
    @NotNull
    private Byte accountType;

    private Byte rtbType;

    /**
     * rtb为快手时返点
     */
    private BigDecimal rebate;

    private Byte allowOcpr;

    private String dataViewingRole;

    private String domain;
    private String activityDomain;
    private String lpDomain;
    /**
     * 小程序链接域名
     */
    private String miniProgramDomain;
    private String pcDomain;

    private String intro;

    private String actRule;

    private String actExplain;

    private Byte activityStatement;

    private String wbAppId;

    private String modifier;

    /**
     * rtb平台appId,(除微博外，其他建议使用统一字段)
     */
    private String rtbAppId;

    /**
     * rtb平台secret(除微博外，其他建议使用统一字段)
     */
    private String rtbSecret;

    /**
     * rtb统一授权的账户名称
     */
    private String rtbSuperAccountName;

    /**
     * rtb统一授权的账户id
     */
    private String rtbSuperAccountId;

    /**
     * 媒体类型ID
     */
    private Long mediaClass;
    /**
     * 媒体子分类ID
     */
    private Long mediaChildClass;

}
