package com.bxm.adsmanager.facade.model.ticket;

import java.util.Date;
import java.util.List;

import org.springframework.format.annotation.DateTimeFormat;

import com.bxm.adsmanager.facade.model.base.BaseDto;
import com.bxm.adsmanager.facade.model.base.Money;

/**
 * <h3>广告券的前端参数模版类</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/07 18:55
 */
public class AdTicketVo extends BaseDto {

    private static final long serialVersionUID = 720632119069996238L;

    private String name;//name

    private Long advertiser;//广告主id   // 调广告主接口

    private String advertiserName;

    private Short settleType;//结算方式：1- CPC、2- CPA、4- CPM

    private String settleTypeText;

    private Double price;//单价

    private Short type;//广告券类型。

    private Double budgetDaily;//日限额（预算），CPC单位是元，CPA单位是张。0 表示无限额。如果是金额，单位：厘

    private String domainCode;//所属行业 广告分类   // tbl_ad_domain 调接口 数据采集

    private Double standaloneCost;//独立成本。百分比

    private String url;//落地页

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date validStartDate;//有效期开始

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date validEndDate;//有效期结束

    @Deprecated
    private Short isSupportWechat;//是否支持微信。0- 不支持、1- 支持
    private String apps;

    private Integer userGradePassScore;//用户评分及格分数线

    private Short status;//状态。0- 暂停、1- 正常、-1 已删除

    private Integer pauseReason;//暂停原因。1- 超出预算、2- 余额不足

    //权重
    private Double weight;  //tbl_ad_ticket_weight_manual_conf 1对1

    //广告素材   调素材添加接口，返回广告券素材列表  传广告素材表id tbl_ad_assets 存入关联表中tbl_ad_ticket_assets_ref
    private String assetsids;

    //广告标签  tbl_ad_tag 调接口 数据采集
    private String tags; //1对多 tbl_ad_rules   1-1-100

    //区域定向  city=城市 缺城市表，然后写接口调城市列表 调 张凯接口  tbl_ad_rules
    private String citys; //1对多 tbl_ad_rules  110000,522501
    //区域定向  ipLibrary=指定ip库
    private String ipLibrary;

    public String getIpLibrary() {
        return ipLibrary;
    }

    public void setIpLibrary(String ipLibrary) {
        this.ipLibrary = ipLibrary;
    }

    //操作平台  数组 json 格式
    private String oss; //1对多  tbl_ad_ticket_os_conf

    //人群定向   要调个推接口匹配数据 json 格式
    private AdTicketPersonsGradeConf ref;  //tbl_ad_ticket_persons_grade_conf 1对1

    private String personsGradeConf;

    //投放控制
    private ControlVo controlVo;
    private Long groupId;
    /**
     * 是否开启广告组
     */
    private Boolean isGroup;

    private Boolean booleanCitys;

    private String createUser;//创建人

    private String modifyUser;//修改人

    private String log;

    private String ae;

    public String getLog() {
        return log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }

    public Boolean getBooleanCitys() {
        return booleanCitys;
    }

    public void setBooleanCitys(Boolean booleanCitys) {
        this.booleanCitys = booleanCitys;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Boolean getIsGroup() {
        return isGroup;
    }

    public void setIsGroup(Boolean isGroup) {
        this.isGroup = isGroup;
    }


    //OCPC
    private OcpcConfVo ocpcConf;

    private List<AdFlowPackageNewVo> adFlows;

    public List<AdFlowPackageNewVo> getAdFlows() {
        return adFlows;
    }

    public void setAdFlows(List<AdFlowPackageNewVo> adFlows) {
        this.adFlows = adFlows;
    }

    private short isEffectMonitor;     //是否接入效果监控; 1-否 2-接入且精确  3-接入但不准

    public static class OcpcConfVo {
        private Short isSupportOcpc;
        private Double cpaExpectPrice;
        private Integer closeThreshold;

        public static OcpcConfVo of(AdTicketOcpcConf orig) {
            if (null == orig) {
                return null;
            }
            OcpcConfVo dest = new OcpcConfVo();
            dest.setCloseThreshold(orig.getCloseThreshold());
            dest.setIsSupportOcpc(orig.getIsSupportOcpc());
            Integer cpaExpectPrice = orig.getCpaExpectPrice();
            if (null != cpaExpectPrice) {
                dest.setCpaExpectPrice(Money.ofLi(cpaExpectPrice).getYuan());
            }
            return dest;
        }

        public Short getIsSupportOcpc() {
            return isSupportOcpc;
        }

        public void setIsSupportOcpc(Short isSupportOcpc) {
            this.isSupportOcpc = isSupportOcpc;
        }

        public Double getCpaExpectPrice() {
            return cpaExpectPrice;
        }

        public void setCpaExpectPrice(Double cpaExpectPrice) {
            this.cpaExpectPrice = cpaExpectPrice;
        }

        public Integer getCloseThreshold() {
            return closeThreshold;
        }

        public void setCloseThreshold(Integer closeThreshold) {
            this.closeThreshold = closeThreshold;
        }
    }

    public static class ControlVo {

        /**
         * 投放时段预算 {start}-{end}-{limit} start=开始时间。单位：小时 end=结束时间。单位：小时 limit=限额。金额或张，
         * 金额单位：前端传递为元，后端保存为厘
         * 1对多 tbl_ad_rules
         */
        private String times;

        /**
         * 投放时段出价 {start}-{end}-{limit}-{price}
         * 金额单位：前端传递为元，后端保存为厘
         * 1对多 tbl_ad_rules
         */
        private String timeBidding;

        //广告位定向   先调用查询所有的广告位接口，传参数type=类型。1- 白名单、2- 黑名单position=广告位ID
        private String banners; //1对多  tbl_ad_rules

        //未获取到用户imei 是否投放
        private String noimei;//tbl_ad_ticket_onoff

        //个推imei未匹配是否投放
        private String imeinomatching; //tbl_ad_ticket_onoff

        /**
         * 频次控制规则 可以不填
         * @see com.bxm.adsmanager.model.enums.RuleTypeEnum.PINCI
         * tbl_ad_rules 1对1
         */
        private String frequencys;

        private String isPackage;

        private Boolean booleanTimes;

        public Boolean getBooleanTimes() {
            return booleanTimes;
        }

        public void setBooleanTimes(Boolean booleanTimes) {
            this.booleanTimes = booleanTimes;
        }

        public String getIsPackage() {
            return isPackage;
        }

        public void setIsPackage(String isPackage) {
            this.isPackage = isPackage;
        }

        public String getTimes() {
            return times;
        }

        public void setTimes(String times) {
            this.times = times;
        }

        public String getTimeBidding() {
            return timeBidding;
        }

        public void setTimeBidding(String timeBidding) {
            this.timeBidding = timeBidding;
        }

        public String getBanners() {
            return banners;
        }

        public void setBanners(String banners) {
            this.banners = banners;
        }

        public String getNoimei() {
            return noimei;
        }

        public void setNoimei(String noimei) {
            this.noimei = noimei;
        }

        public String getImeinomatching() {
            return imeinomatching;
        }

        public void setImeinomatching(String imeinomatching) {
            this.imeinomatching = imeinomatching;
        }

        public String getFrequencys() {
            return frequencys;
        }

        public void setFrequencys(String frequencys) {
            this.frequencys = frequencys;
        }

    }


    public AdTicketPersonsGradeConf getRef() {
        return ref;
    }

    public void setRef(AdTicketPersonsGradeConf ref) {
        this.ref = ref;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getAdvertiser() {
        return advertiser;
    }

    public void setAdvertiser(Long advertiser) {
        this.advertiser = advertiser;
    }

    public Short getSettleType() {
        return settleType;
    }

    public void setSettleType(Short settleType) {
        this.settleType = settleType;
    }

    public Double getPrice() {
        return price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public Short getType() {
        return type;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public Double getBudgetDaily() {
        return budgetDaily;
    }

    public void setBudgetDaily(Double budgetDaily) {
        this.budgetDaily = budgetDaily;
    }

    public String getDomainCode() {
        return domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public Double getStandaloneCost() {
        return standaloneCost;
    }

    public void setStandaloneCost(Double standaloneCost) {
        this.standaloneCost = standaloneCost;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getValidStartDate() {
        return validStartDate;
    }

    public void setValidStartDate(Date validStartDate) {
        this.validStartDate = validStartDate;
    }

    public Date getValidEndDate() {
        return validEndDate;
    }

    public void setValidEndDate(Date validEndDate) {
        this.validEndDate = validEndDate;
    }

    public Short getIsSupportWechat() {
        return isSupportWechat;
    }

    public void setIsSupportWechat(Short isSupportWechat) {
        this.isSupportWechat = isSupportWechat;
    }

    public Integer getUserGradePassScore() {
        return userGradePassScore;
    }

    public void setUserGradePassScore(Integer userGradePassScore) {
        this.userGradePassScore = userGradePassScore;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public Integer getPauseReason() {
        return pauseReason;
    }

    public void setPauseReason(Integer pauseReason) {
        this.pauseReason = pauseReason;
    }

    public String getAssetsids() {
        return assetsids;
    }

    public void setAssetsids(String assetsids) {
        this.assetsids = assetsids;
    }

    public ControlVo getControlVo() {
        return controlVo;
    }

    public void setControlVo(ControlVo controlVo) {
        this.controlVo = controlVo;
    }

    public String getTags() {
        return tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getCitys() {
        return citys;
    }

    public void setCitys(String citys) {
        this.citys = citys;
    }

    public String getOss() {
        return oss;
    }

    public void setOss(String oss) {
        this.oss = oss;
    }

    public Double getWeight() {
        return weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public String getPersonsGradeConf() {
        return personsGradeConf;
    }

    public void setPersonsGradeConf(String personsGradeConf) {
        this.personsGradeConf = personsGradeConf;
    }

    public String getAdvertiserName() {
        return advertiserName;
    }

    public void setAdvertiserName(String advertiserName) {
        this.advertiserName = advertiserName;
    }

    public OcpcConfVo getOcpcConf() {
        return ocpcConf;
    }

    public void setOcpcConf(OcpcConfVo ocpcConf) {
        this.ocpcConf = ocpcConf;
    }

    public short getIsEffectMonitor() {
        return isEffectMonitor;
    }

    public void setIsEffectMonitor(short isEffectMonitor) {
        this.isEffectMonitor = isEffectMonitor;
    }

    public String getSettleTypeText() {
        if (null != this.getSettleType()) {
            if (1 == this.getSettleType().intValue()) {
                return "CPC";
            } else if (2 == this.getSettleType().intValue()) {
                return "CPA";
            }
        }
        return settleTypeText;
    }

    public void setSettleTypeText(String settleTypeText) {
        this.settleTypeText = settleTypeText;
    }

    public String getAe() {
        return ae;
    }

    public void setAe(String ae) {
        this.ae = ae;
    }

    public String getApps() {
        return apps;
    }

    public void setApps(String apps) {
        this.apps = apps;
    }
}
