package com.bxm.adsmanager.facade.service;

import com.bxm.adsmanager.facade.constant.Constants;
import com.bxm.adsmanager.facade.model.position.PositionMonitorRoiResult;
import com.bxm.adsmanager.facade.model.ticket.AdTicketMonitorResult;
import com.bxm.adsmanager.facade.model.ticket.AdTicketVo;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 监控项目修改券状态为待审核
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface AdTicketFacadeService {


    /**
     * 监控项目修改券状态为待审核
     * @param id
     * @return Boolean
     */
    @RequestMapping(value = "/adTicket/updateStatusBySentinel", method = RequestMethod.GET)
    public ResultModel<Boolean> update(@RequestParam(required = true, name = "id" ) Long id);

    /**
     * 根据券id获取ae名字
     * @param id
     * @return Boolean
     */
    @RequestMapping(value = "/adTicket/getAeCodeByTicketId", method = RequestMethod.GET)
    public ResultModel<String> getAeCodeByTicketId(@RequestParam(required = true, name = "id" ) Long id);


    @RequestMapping(value = "/facade/monitor/adTicket/checkMonitor", method = RequestMethod.GET)
    public ResultModel<AdTicketMonitorResult> monitorTicket(
                                              @RequestParam(required = true, name = "amountLimit") String amountLimit,
                                              @RequestParam(required = true, name = "ticketId") String ticketId,
                                              @RequestParam(required = false,name = "positionId") String positionId );

    @RequestMapping(value = "/facade/monitor/adTicket/monitorRoi", method = RequestMethod.GET)
    public ResultModel<PositionMonitorRoiResult> monitorRoi(@RequestParam(required = true,name = "appkey") String appkey,
                                                               @RequestParam(required = true,name = "positionId") String positionId);

    @GetMapping(value = "/adTicket/find")
    public  ResultModel<AdTicketVo> find(@RequestParam("id") Long id);


    @GetMapping(value = "/adTicket/facade/findTicketByParams")
    ResultModel<List<AdTicketVo>> findTicketByParams(@RequestParam(name = "pageSize",defaultValue = "20") Integer pageSize,
                                                     @RequestParam(name = "pageNum",defaultValue = "1") Integer pageNum,
                                                     @RequestParam(required = false,name = "ticketIdOrName") String ticketIdOrName);

    @GetMapping(value = "/adTicket/facade/findIdByIdOrName")
    ResultModel<List<Long>> findIdByIdOrName(@RequestParam(required = false,name = "ticketIdOrName") String ticketIdOrName);
}
