package com.bxm.adsmanager.facade.service;

import com.bxm.adsmanager.facade.constant.Constants;
import com.bxm.adsmanager.facade.model.advertiser.AdRegionVo;
import com.bxm.adsmanager.facade.model.ticket.AdAssets;
import com.bxm.adsmanager.facade.model.ticket.AdTicketDto;
import com.bxm.adsmanager.facade.model.ticket.AdTicketVo;
import com.bxm.adsmanager.facade.model.video.VideoAssetDto;
import com.bxm.adsmanager.facade.model.video.VideoAssetVo;
import com.bxm.warcar.utils.response.ResultModel;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wangchao
 * @description 广告主券相关接口
 * @date 2019/04/09 16:48
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface AdvertiserApiFacadeService {
    /**
     * @return ResultModel
     * @Title: update
     * @Description: 地域查询api
     */
    @RequestMapping(value = "/advertiser/queryRegionApi", method = RequestMethod.POST)
    List<AdRegionVo> queryRegionApi(@RequestBody List<Long> ticketIds);

    /**
     * @return ResultModel
     * @Title: update
     * @Description: 地域更新api
     */
    @RequestMapping(value = "/advertiser/updateRegionApi", method = RequestMethod.POST)
    String updateRegionApi(@RequestParam(name = "advertiserId") Integer advertiserId,
                                   @RequestParam(name = "ticketIds") List<Long> ticketIds,
                                   @RequestParam(name = "updateType") Integer updateType,
                                   @RequestParam(name = "region") String region);
}
