package com.bxm.adsmanager.facade.service;

import com.bxm.adsmanager.facade.constant.Constants;
import com.bxm.adsmanager.facade.model.advertiser.AdRegionVo;
import com.bxm.adsmanager.facade.model.ticket.AdAssets;
import com.bxm.adsmanager.facade.model.ticket.AdTicketDto;
import com.bxm.adsmanager.facade.model.ticket.AdTicketVo;
import com.bxm.adsmanager.facade.model.video.VideoAssetDto;
import com.bxm.adsmanager.facade.model.video.VideoAssetVo;
import com.bxm.warcar.utils.response.ResultModel;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wangchao
 * @description 广告主券相关接口
 * @date 2019/04/09 16:48
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface AdvertiserTicketFacadeService {

    @RequestMapping(value = "/advertiser/updateAdTicket", method = RequestMethod.POST)
    ResultModel update(@RequestParam(required = true, name = "id") Long id,
                       @RequestParam(required = true, name = "status") Short status);


    @RequestMapping(value = "/advertiser/updateDailyBudget", method = RequestMethod.POST)
    ResultModel update(@RequestParam(required = true, name = "id") Long id,
                       @RequestParam(required = true, name = "dailyBudget") Double dailyBudget);


    @RequestMapping(value = "/advertiser/getAdvertiserBalance", method = RequestMethod.GET)
    ResultModel getAdvertiserBalance(@RequestParam(required = true, name = "id") Long id);


    @RequestMapping(value = "/advertiser/reUpdateAdTicket", method = RequestMethod.POST)
    ResultModel reUpdate(@RequestParam(required = true, name = "id") Long id,
                         @RequestParam(required = true, name = "status") Short status);


    @RequestMapping(value = "/advertiser/findBalanceByIds", method = RequestMethod.POST)
    ResultModel findBalanceByIds(@RequestParam(value = "advertiserIds") List<Integer> advertiserIds);

    /*以下是新接口*/

    @RequestMapping(value = "/advertiser/addAdAssets", method = RequestMethod.POST)
    ResultModel<Long> addAssets(@RequestBody AdAssets adAssets);

    @RequestMapping(value = "/advertiser/updateAdAssets", method = RequestMethod.POST)
    ResultModel<String> updateAssets(@RequestBody AdAssets adAssets);


    @RequestMapping(value = "/advertiser/queryAdvertiserByParam", method = RequestMethod.GET)
    ResultModel<Long> queryAdvertiserByParam(@RequestParam(required = false, name = "adAssetId") Long adAssetId,
                                             @RequestParam(required = false, name = "ticketId") Long ticketId);


    @RequestMapping(value = "/advertiser/delAdAssets", method = RequestMethod.DELETE)
    ResultModel<Boolean> deleteAssets(@RequestParam(required = true, name = "id") String id);


    @RequestMapping(value = "/advertiser/findAllAssets", method = RequestMethod.GET)
    ResultModel<List<AdAssets>> findAllAssets(@RequestParam(required = true, name = "ids") String ids);

    @RequestMapping(value = "/advertiser/findAllAssetsByTicketId", method = RequestMethod.GET)
    ResultModel<List<AdAssets>> findAllAssetsByTicketId(@RequestParam(required = true, name = "ticketId") Long ticketId);


    @RequestMapping(value = "/advertiser/addTicket", method = RequestMethod.POST, produces = "application/json")
    ResultModel<Long> addTicket(@RequestBody AdTicketDto adTicketDto);

    @RequestMapping(value = "/advertiser/updateTicket", method = RequestMethod.POST, produces = "application/json")
    ResultModel<Boolean> updateTicket(@RequestBody AdTicketDto adTicketDto);

    @RequestMapping(value = "/advertiser/getTicketById", method = RequestMethod.GET)
    ResultModel<AdTicketVo> find(@RequestParam(required = true, name = "id") Long id);


    @RequestMapping(value = "/advertiser/videoAsset/saveOrUpdate", method = RequestMethod.GET)
    public ResultModel saveOrUpdate(@RequestBody VideoAssetDto dto);

    /**
     * 视频素材修改状态
     *
     * @return
     */
    @RequestMapping(value = "/advertiser/videoAsset/updateStatus", method = RequestMethod.GET)
    public ResultModel updateStatus(@RequestParam(value = "status", required = true) Short status,
                                    @RequestParam(value = "id", required = true) Long id,
                                    @RequestParam(value = "userName", required = true) String userName);

    /**
     * 查找列表
     * @param pageNum
     * @param pageSize
     * @param keywords
     * @param advertiserIds
     * @return
     */
    @RequestMapping(value = "/advertiser/videoAsset/getList", produces = "application/json")
    public ResultModel<PageInfo<VideoAssetVo>> getList(
            @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum,
            @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,
            @RequestParam(value = "keywords", required = false) String keywords,
            @RequestBody List<Long> advertiserIds);


    /**
     * 视频素材修改状态
     *
     * @return
     */
    @RequestMapping(value = "/advertiser/videoAsset/getVideoAsset", method = RequestMethod.GET)
    public ResultModel<VideoAssetVo> getVideoAsset(@RequestParam(value = "id", required = true) Long id ,
                                                   @RequestParam(value = "advertiserId", required = true) Long advertiserId
    );

    @RequestMapping(value = "/advertiser/checkTicketExistAssets", method = RequestMethod.GET)
    ResultModel<Boolean> checkTicketExistAssets(@RequestParam(name = "ticketId") Long ticketId);


    /**
     *  修改广告主总日预算
     * @param id
     * @param dailyBudget
     * @return
     */
    @RequestMapping(value = "/advertiser/updateAdvertiserDailyBudget", method = RequestMethod.POST)
    ResultModel<Boolean> updateAdvertiserDailyBudget(@RequestParam(required = true, name = "id") Integer id,
                                                     @RequestParam(required = true, name = "dailyBudget") BigDecimal dailyBudget);


    @RequestMapping(value = "/advertiser/checkAssetsByTicketIds", method = RequestMethod.GET, produces = "application/json")
    ResultModel<String> checkAssetsByTicketIds(@RequestParam(name = "ticketIds") String ticketIds);


    /**
     * @return ResultModel
     * @Title: update
     * @Description: 批量修改地区
     */
    @RequestMapping(value = "/advertiser/batchUpdateTicketRegion", method = RequestMethod.POST)
    public ResultModel<Boolean> batchUpdateTicketRegion(@RequestParam(required = true, name = "ticketIds") String ticketIds,
                                                        @RequestParam(required = false, name = "citys") String citys);
}
