package com.bxm.adsmanager.facade.service;

import com.bxm.adsmanager.facade.constant.Constants;
import com.bxm.adsmanager.facade.model.adx.AdxSyncFileDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @author zhangdong
 * @date 2022/11/17
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface AdxCreativeSyncFacadeService {

    /**
     * adx素材同步接口
     * @param dto
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/facade/adx/creative/sync", method = RequestMethod.POST)
    void upload(@RequestBody List<AdxSyncFileDTO> dto) ;
}
