/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.integration.adsmanager;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.facade.model.ticket.AdTicketCostLog;
import com.bxm.adsmanager.facade.service.AdsprodTicketFacadeService;
import com.bxm.adsmanager.facade.service.StationUserWeightFacadeService;
import com.bxm.adsprod.integration.adsmanager.AdsmanagerService;
import com.bxm.warcar.utils.response.ResultModel;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Configuration;

@EnableFeignClients(value={"com.bxm.adsmanager.facade", "com.bxm.adsmanager.facade.service"})
@Configuration
public class AdsmanagerServiceImpl
implements AdsmanagerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdsmanagerServiceImpl.class);
    @Autowired
    private AdsprodTicketFacadeService adsprodTicketFacadeService;
    @Autowired
    private StationUserWeightFacadeService stationUserWeightFacadeService;

    @Override
    public boolean updateAdTicket(BigInteger ticketId, byte status, int reason) {
        ResultModel resultModel = this.adsprodTicketFacadeService.update(Long.valueOf(ticketId.longValue()), Integer.valueOf(reason), Short.valueOf(status));
        return resultModel.isSuccessed();
    }

    @Override
    public boolean addTicketCostLog(BigInteger ticketId, double costRds, double cost) {
        AdTicketCostLog adTicketCostLog = new AdTicketCostLog();
        adTicketCostLog.setTicketId(Long.valueOf(ticketId.longValue()));
        adTicketCostLog.setCostRds(Double.valueOf(costRds));
        adTicketCostLog.setCost(Double.valueOf(cost));
        ResultModel resultModel = this.adsprodTicketFacadeService.addTicketCostLog(adTicketCostLog);
        if (!resultModel.isSuccessed()) {
            LOGGER.warn("addTicketCostLog failed ,ticketId is {}, resultModel is {}", (Object)ticketId, (Object)JSON.toJSONString((Object)resultModel));
        }
        return resultModel.isSuccessed();
    }

    @Override
    public Boolean stationUserWeightComplete(Long stationUserWeightId) {
        ResultModel resultModel = this.stationUserWeightFacadeService.complete(stationUserWeightId);
        return resultModel.isSuccessed();
    }

    @Override
    public Boolean updateTicketCouponsCode(BigInteger ticketId, Short status, Long firstShowTime, Long useTime, String usePositionId, String bindDeviceNo, String couponsCode) {
        ResultModel resultModel = this.adsprodTicketFacadeService.updateTicketCouponsCode(Long.valueOf(ticketId.longValue()), status, firstShowTime, useTime, usePositionId, bindDeviceNo, couponsCode);
        return resultModel.isSuccessed();
    }
}

