/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.validate.internal;

import com.bxm.warcar.validate.AbstractValidator;
import com.bxm.warcar.validate.ConstraintViolationException;
import com.bxm.warcar.validate.ValidateException;
import java.lang.reflect.Field;

public class LengthValidator
extends AbstractValidator {
    private final int minLen;
    private final int maxLen;

    public LengthValidator(Field field, int minLen, int maxLen) {
        super(field);
        if (minLen < 0) {
            throw new IllegalArgumentException("minLen:" + minLen);
        }
        if (minLen > maxLen) {
            throw new IllegalArgumentException("minLen:" + minLen + " maxLen:" + maxLen);
        }
        this.minLen = minLen;
        this.maxLen = maxLen;
    }

    public LengthValidator(Field field, int minLen, int maxLen, String value) {
        super(field, value);
        if (minLen < 0) {
            throw new IllegalArgumentException("minLen:" + minLen);
        }
        if (minLen > maxLen) {
            throw new IllegalArgumentException("minLen:" + minLen + " maxLen:" + maxLen);
        }
        this.minLen = minLen;
        this.maxLen = maxLen;
    }

    @Override
    protected void doValidate(Object input) throws Exception {
        Object v = this.getValue(input);
        String defaultValue = this.getDefaultValue();
        if (null == v) {
            if (defaultValue != null) {
                this.setValue(input, defaultValue);
                return;
            }
            throw new ConstraintViolationException(this, "null");
        }
        if (!(v instanceof String)) {
            if (defaultValue != null) {
                this.setValue(input, defaultValue);
                return;
            }
            throw new ValidateException("Expect String,but " + v);
        }
        String sv = (String)v;
        int l = sv.length();
        if (l < this.minLen || l > this.maxLen) {
            if (defaultValue != null) {
                this.setValue(input, defaultValue);
                return;
            }
            throw new ConstraintViolationException(this, "value:" + sv);
        }
    }

    @Override
    public String getConstraintDesc() {
        return this.getFieldDesc() + " length range:[" + this.minLen + "," + this.maxLen + "]";
    }
}

