/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.api;

import com.bxm.adsprod.api.AdsprodApiProperties;
import com.bxm.warcar.configure.spring.SpringBootEnvironmentListener;
import com.bxm.warcar.sc.domain.autoconfigure.EnableStaticResourceDomainRepalceHandler;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@EnableDiscoveryClient
@EnableStaticResourceDomainRepalceHandler
@SpringBootApplication
@ComponentScan(value={"com.bxm"})
@EnableConfigurationProperties(value={AdsprodApiProperties.class})
@EnableFeignClients(value={"com.bxm.adsprod.facade"})
public class AdsprodApiApplication {
    public static void main(String[] args) {
        SpringApplication application = new SpringApplication(new Class[]{AdsprodApiApplication.class});
        application.addListeners(new ApplicationListener[]{new SpringBootEnvironmentListener()});
        application.run(args);
    }

    @Bean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedHeader("*");
        config.addAllowedOrigin("*");
        config.setMaxAge(Long.valueOf(18000L));
        config.addAllowedMethod("OPTIONS");
        config.addAllowedMethod("HEAD");
        config.addAllowedMethod("GET");
        config.addAllowedMethod("PUT");
        config.addAllowedMethod("POST");
        config.addAllowedMethod("DELETE");
        config.addAllowedMethod("PATCH");
        source.registerCorsConfiguration("/**", config);
        return new CorsFilter((CorsConfigurationSource)source);
    }
}

