/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.api.controller;

import com.bxm.adsprod.facade.award.Award;
import com.bxm.adsprod.facade.award.AwardDto;
import com.bxm.adsprod.facade.award.AwardService;
import com.bxm.adsprod.facade.award.FetchAwardDto;
import com.bxm.adsprod.facade.award.OutSideDto;
import com.bxm.adsprod.facade.award.UserAwardDto;
import com.bxm.adsprod.facade.award.UserAwardVo;
import com.bxm.adsprod.facade.ticket.TicketOutsideService;
import com.bxm.monitor.util.impl.CodeValidateImgServiceImpl;
import com.bxm.warcar.sc.domain.StaticResourceMapping;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/award"})
public class AwardController {
    Logger logger = LoggerFactory.getLogger(AwardController.class);
    @Autowired
    private AwardService awardService;
    @Autowired
    private TicketOutsideService ticketOutsideService;
    @Autowired
    private CodeValidateImgServiceImpl codeValidateImgServiceImpl;
    private final Award[] backupsForIos = new Award[]{this.create14503(), this.create14504()};
    private final Award[] backupsForAndroid = new Award[]{this.create14503(), this.create14504()};

    private Award create14503() {
        Award o = new Award();
        o.setAssetsId(11512L);
        o.setAwardangle("300");
        o.setAwardid(14503L);
        o.setAwardimg("https://m.cudaojia.com/dist/ACTIVITY/certificate/2019/01/09/1c9c91f2-8b9e-4fae-9316-170cbc9e15f2.gif");
        o.setAwardlink("https://lp.tandehao.com/dist/adPages/P100/index01.html");
        o.setAwardname("\u798f\u52290\u5143\u8d2d\uff0c\u5173\u6ce8\u9886\u5927\u5956\uff01");
        o.setAwardtype(2);
        o.setButtontext("\u7acb\u5373\u9886\u53d6");
        o.setIsShieldPopup("0");
        o.setLandingType(0);
        o.setShopstype(59);
        o.setValiditytime("2099-01-01");
        return o;
    }

    private Award create14504() {
        Award o = new Award();
        o.setAssetsId(11514L);
        o.setAwardangle("300");
        o.setAwardid(14504L);
        o.setAwardimg("https://m.cudaojia.com/dist/ACTIVITY/certificate/2019/01/09/639f45dc-5503-4089-871a-1ecfe8b1b178.gif");
        o.setAwardlink("https://lp.tandehao.com/dist/adPages/P100/index01.html");
        o.setAwardname("\u798f\u52290\u5143\u8d2d\uff0c\u5173\u6ce8\u9886\u5927\u5956\uff01");
        o.setAwardtype(2);
        o.setButtontext("\u7acb\u5373\u9886\u53d6");
        o.setIsShieldPopup("0");
        o.setLandingType(0);
        o.setShopstype(59);
        o.setValiditytime("2099-01-01");
        return o;
    }

    @StaticResourceMapping
    @RequestMapping(value={"/awardInfo"}, method={RequestMethod.POST})
    public ResponseModel awardInfo(AwardDto awardDto) {
        try {
            Award award = this.awardService.get(awardDto);
            return ResponseModelFactory.SUCCESS((Object)award);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5e7f\u544a\u5238\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
            int os = NumberUtils.toInt((String)awardDto.getAppos(), (int)1);
            Award backup = os == 2 ? this.backupsForIos[RandomUtils.nextInt((int)this.backupsForIos.length)] : this.backupsForAndroid[RandomUtils.nextInt((int)this.backupsForAndroid.length)];
            return ResponseModelFactory.SUCCESS((Object)backup);
        }
    }

    @RequestMapping(value={"/fetchAward"}, method={RequestMethod.POST})
    public ResponseModel fetchAward(FetchAwardDto acceptAwardDto) {
        boolean success = this.awardService.fetch(acceptAwardDto);
        if (success) {
            return ResponseModelFactory.getResponseModel();
        }
        return ResponseModelFactory.FAILED();
    }

    @StaticResourceMapping
    @RequestMapping(value={"/userAwardList"}, method={RequestMethod.GET})
    public ResponseModel userAwardList(UserAwardDto userAwardDto) {
        List<UserAwardVo> userAwardVoList = this.awardService.fetchUserAward(userAwardDto);
        return ResponseModelFactory.SUCCESS(userAwardVoList);
    }

    @RequestMapping(value={"/putInfo"}, method={RequestMethod.GET})
    public void putInfo(OutSideDto outSideDto, HttpServletRequest request, HttpServletResponse response) {
        String url = "http://i.tandehao.com/activities/?appKey=fbca14bb5bb74d5a9b5fa165ad78a15a&appType=app&appEntrance=1&business=money&i=__IMEI__&f=__IDFA__";
        if (StringUtils.isEmpty((CharSequence)outSideDto.getAssetId())) {
            this.logger.warn("assetId is Empty");
        } else {
            try {
                String userAgent = request.getHeader("User-Agent");
                String referrer = request.getHeader("Referer");
                url = this.ticketOutsideService.getNewTicketUrl(outSideDto.getAssetId(), outSideDto.getIpaddress(), outSideDto.getIsSupplement(), userAgent, referrer);
            }
            catch (Exception e) {
                this.logger.error("ticketOutsideService.getTicketUrl error", (Throwable)e);
            }
        }
        try {
            response.sendRedirect(url);
        }
        catch (IOException e) {
            this.logger.error("AwardController.putInfo sendRedirect error", (Throwable)e);
        }
    }

    @RequestMapping(value={"/getImgCode"}, method={RequestMethod.GET})
    public ResponseModel getImgCode(HttpServletRequest req) {
        return ResponseModelFactory.SUCCESS((Object)this.codeValidateImgServiceImpl.getValidateImgInfo(req));
    }

    @RequestMapping(value={"/validateCode"}, method={RequestMethod.GET})
    public ResponseModel validateCode(HttpServletRequest req) {
        Boolean b = this.codeValidateImgServiceImpl.validateCode(req);
        if (b.booleanValue()) {
            return ResponseModelFactory.SUCCESS((Object)b, (Integer)1, (String)"\u6821\u9a8c\u6210\u529f");
        }
        return ResponseModelFactory.SUCCESS((Object)b, (Integer)1, (String)"\u6821\u9a8c\u5931\u8d25");
    }
}

