/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.api.service;

import com.bxm.adsprod.api.AdsprodApiProperties;
import com.bxm.adsprod.api.service.MiSportService;
import com.bxm.adsprod.api.service.Signature;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.StringHelper;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DefaultMiSportServiceImpl
implements MiSportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMiSportServiceImpl.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private AdsprodApiProperties properties;
    private final RestTemplate rest = new RestTemplateBuilder(new RestTemplateCustomizer[0]).setConnectTimeout(5000).build();

    @Override
    public String getToken() {
        return (String)this.fetcher.fetch(() -> KeyBuilder.build((Object[])new Object[]{"TMP", "MISPORT", "ACCESS_TOKEN"}), this::getToken0, String.class, 7000);
    }

    private String getToken0() {
        AdsprodApiProperties.Mi mi = this.properties.getMi();
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"appkey", (Object)mi.getAppkey());
        form.add((Object)"appsecret", (Object)mi.getAppsecret());
        ResponseEntity entity = this.rest.postForEntity(mi.getAccessTokenUrl(), (Object)form, AccessTokenResponse.class, new Object[0]);
        AccessTokenResponse body = (AccessTokenResponse)entity.getBody();
        if (null == body) {
            LOGGER.warn("\u6ca1\u6709\u83b7\u53d6\u5230\u6b63\u786e\u7684\u5185\u5bb9");
            return null;
        }
        String accessToken = body.getAccess_token();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            LOGGER.warn("\u6ca1\u6709\u83b7\u53d6\u5230\u6b63\u786e\u7684AccessToken\uff0c\u54cd\u5e94\uff1a{}", (Object)body);
            return null;
        }
        return accessToken;
    }

    @Override
    public Signature signature(String url) {
        String token = this.getToken();
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new RuntimeException("access_token does not exist!");
        }
        TreeMap param = Maps.newTreeMap();
        String appkey = this.properties.getMi().getAppkey();
        param.put("appkey", appkey);
        String nonce = StringHelper.random((int)15);
        param.put("noncestr", nonce);
        param.put("access_token", token);
        String time = TypeHelper.castToString((Object)(System.currentTimeMillis() / 1000L));
        param.put("timestamp", time);
        param.put("url", url);
        String source = this.convert(param);
        String sign = DigestUtils.sha1Hex((String)source);
        return new Signature(appkey, time, nonce, sign);
    }

    private String convert(Map<String, String> param) {
        StringBuilder str = new StringBuilder();
        Set<Map.Entry<String, String>> entries = param.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            str.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        return StringUtils.removeEnd((String)str.toString(), (String)"&");
    }

    public static final class AccessTokenResponse
    implements Serializable {
        private static final long serialVersionUID = 3439605826047616977L;
        private String access_token;
        private Integer expires_in;
        private Integer error_code;
        private String error_massage;

        String getAccess_token() {
            return this.access_token;
        }

        public void setAccess_token(String access_token) {
            this.access_token = access_token;
        }

        public Integer getExpires_in() {
            return this.expires_in;
        }

        public void setExpires_in(Integer expires_in) {
            this.expires_in = expires_in;
        }

        public Integer getError_code() {
            return this.error_code;
        }

        public void setError_code(Integer error_code) {
            this.error_code = error_code;
        }

        public String getError_massage() {
            return this.error_massage;
        }

        public void setError_massage(String error_massage) {
            this.error_massage = error_massage;
        }

        public String toString() {
            return "AccessTokenResponse{access_token='" + this.access_token + '\'' + ", expires_in=" + this.expires_in + ", error_code=" + this.error_code + ", error_massage='" + this.error_massage + '\'' + '}';
        }
    }
}

