/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.monitor.util.commons;

import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class RedisClientByCode {
    @Autowired
    @Qualifier(value="jedisPool")
    private JedisPool jedisPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            String string = jedis.get(key);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, String value, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.set(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWithTimeAndDB(String key, String value, Long seconds, Integer dbIndex) {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            jedis.set(key, value);
            if (seconds != null) {
                jedis.expire(key, seconds.intValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delByKeys(String redisKey, Integer dbIndex) {
        try (Jedis jedis = null;){
            Set keys;
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            if ((keys = jedis.keys(redisKey)) != null && keys.size() > 0) {
                for (String key : keys) {
                    jedis.del(key);
                }
            }
        }
    }
}

