/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.monitor.util.impl;

import com.bxm.monitor.util.commons.RedisClientByCode;
import com.bxm.monitor.util.constant.MonitorRedisConstant;
import com.bxm.monitor.util.model.ValidateImgInfo;
import com.bxm.monitor.util.service.CodeValidateImgService;
import com.bxm.warcar.utils.HttpUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.helper.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CodeValidateImgServiceImpl
implements CodeValidateImgService {
    @Autowired
    private RedisClientByCode redisClient;

    @Override
    public Boolean isCodeValidateImg(HttpServletRequest request) {
        String spm = CodeValidateImgServiceImpl.getSpmByRefer(request);
        if (StringUtils.isBlank((CharSequence)spm)) {
            return false;
        }
        String ipAddress = HttpUtils.getIpFromHeader((HttpServletRequest)request);
        String ipKey = MonitorRedisConstant.connectRedisKey("dting", "cheat:ip", ipAddress);
        String spmKey = MonitorRedisConstant.connectRedisKey("dting", "cheat:spm", spm);
        String userAgent = request.getHeader("User-Agent");
        if (StringUtil.isBlank((String)userAgent)) {
            return this.isFirst(spmKey);
        }
        if (!CodeValidateImgServiceImpl.isMobileDevice(userAgent)) {
            return this.isFirst(spmKey);
        }
        String value = this.redisClient.get(ipKey, MonitorRedisConstant.DBINDEX);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return this.isFirst(spmKey);
        }
        return false;
    }

    public Boolean isFirst(String spmKey) {
        String isFirstValue = this.redisClient.get(spmKey, MonitorRedisConstant.DBINDEX);
        if (StringUtils.equalsIgnoreCase((CharSequence)"10000", (CharSequence)isFirstValue)) {
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)isFirstValue)) {
            this.redisClient.setWithTimeAndDB(spmKey, "1", MonitorRedisConstant.EXPIRY_TIME, MonitorRedisConstant.DBINDEX);
        }
        return true;
    }

    public ValidateImgInfo getValidateImgInfo(HttpServletRequest request) {
        ValidateImgInfo vi = new ValidateImgInfo();
        Random random = new Random();
        int templateNo = random.nextInt(MonitorRedisConstant.img.length);
        String[] img = MonitorRedisConstant.img[templateNo].split(",");
        vi.setImg1("https://m.cudaojia.com/codeimage/" + img[0]);
        vi.setImg2("https://m.cudaojia.com/codeimage/" + img[1]);
        vi.setMove(Integer.parseInt(img[2]));
        String spm = request.getParameter("spm");
        String spmKey = MonitorRedisConstant.connectRedisKey("dting", "cheat:spm", spm);
        this.redisClient.setWithTimeAndDB(spmKey, vi.getMove().toString(), MonitorRedisConstant.EXPIRY_TIME, MonitorRedisConstant.DBINDEX);
        return vi;
    }

    public Boolean validateCode(HttpServletRequest request) {
        String movex = request.getParameter("moveX");
        String spm = request.getParameter("spm");
        if (StringUtils.isEmpty((CharSequence)movex) || StringUtils.isEmpty((CharSequence)"spm")) {
            return false;
        }
        String key = MonitorRedisConstant.connectRedisKey("dting", "cheat:spm", spm);
        String value = this.redisClient.get(key, MonitorRedisConstant.DBINDEX);
        if (!StringUtils.isNotEmpty((CharSequence)value) || Integer.parseInt(value) + 30 < Integer.parseInt(movex) || Integer.parseInt(value) - 30 > Integer.parseInt(movex)) {
            return false;
        }
        this.redisClient.setWithTimeAndDB(key, "10000", MonitorRedisConstant.EXPIRY_TIME, MonitorRedisConstant.DBINDEX);
        return true;
    }

    private static boolean isMobileDevice(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        String[] deviceArray = new String[]{"android", "iphone", "ipad", "ipod", "windows phone", "symbianos", "blackberry", "windows mobile"};
        userAgent = userAgent.toLowerCase();
        int i = 0;
        while (i < deviceArray.length) {
            if (userAgent.indexOf(deviceArray[i]) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getStartAndEndTime() {
        String key = MonitorRedisConstant.connectRedisKey("dting", "startAndendTime");
        String value = this.redisClient.get(key, MonitorRedisConstant.DBINDEX);
        if (StringUtils.isBlank((CharSequence)value) || StringUtils.isNotEmpty((CharSequence)value) && value.trim().split(",").length != 2) {
            return null;
        }
        return value;
    }

    public static String getSpmByRefer(HttpServletRequest request) {
        String refer = request.getHeader("Referer");
        if (StringUtils.isEmpty((CharSequence)refer)) {
            return null;
        }
        String spm = null;
        List<String> s = Arrays.asList(refer.split("&"));
        for (String sp : s) {
            if (sp.indexOf("spm=lti") == -1) continue;
            spm = sp.split("=")[1];
            break;
        }
        return spm;
    }
}

