/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.create.table;

import java.util.List;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.Index;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;

public class CreateTable
implements Statement {
    private Table table;
    private boolean unlogged = false;
    private List<String> createOptionsStrings;
    private List<String> tableOptionsStrings;
    private List<ColumnDefinition> columnDefinitions;
    private List<Index> indexes;
    private Select select;
    private boolean ifNotExists = false;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public boolean isUnlogged() {
        return this.unlogged;
    }

    public void setUnlogged(boolean unlogged) {
        this.unlogged = unlogged;
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public void setColumnDefinitions(List<ColumnDefinition> list) {
        this.columnDefinitions = list;
    }

    public List<?> getTableOptionsStrings() {
        return this.tableOptionsStrings;
    }

    public void setTableOptionsStrings(List<String> list) {
        this.tableOptionsStrings = list;
    }

    public List<String> getCreateOptionsStrings() {
        return this.createOptionsStrings;
    }

    public void setCreateOptionsStrings(List<String> createOptionsStrings) {
        this.createOptionsStrings = createOptionsStrings;
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<Index> list) {
        this.indexes = list;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public String toString() {
        String createOps = PlainSelect.getStringList(this.createOptionsStrings, false, false);
        String sql = "CREATE " + (this.unlogged ? "UNLOGGED " : "") + (!"".equals(createOps) ? createOps + " " : "") + "TABLE " + (this.ifNotExists ? "IF NOT EXISTS " : "") + this.table;
        if (this.select != null) {
            sql = sql + " AS " + this.select.toString();
        } else {
            sql = sql + " (";
            sql = sql + PlainSelect.getStringList(this.columnDefinitions, true, false);
            if (this.indexes != null && !this.indexes.isEmpty()) {
                sql = sql + ", ";
                sql = sql + PlainSelect.getStringList(this.indexes);
            }
            sql = sql + ")";
            String options = PlainSelect.getStringList(this.tableOptionsStrings, false, false);
            if (options != null && options.length() > 0) {
                sql = sql + " " + options;
            }
        }
        return sql;
    }
}

