#!/bin/bash

if [ ! -f ~/run/adsprod-api.pid ]; then
  echo "Server [adsprod-api] doest not started!"
  exit
fi

pid=`cat ~/run/adsprod-api.pid`
if [ ! -n "${pid}" ]; then
  echo "illegal content in adsprod-api.pid!"
  exit
fi

process=`ps -aux|awk '{print $2}' | grep ${pid}`
if [ -n "${process}" ]; then
  echo "Server [adsprod-api] will be stop."
  kill ${pid}

  times=0
  while true
  do
    process=`ps -aux|awk '{print $2}' | grep ${pid}`
    if [ -n "${process}" ] && [ ${times} -lt 10 ]; then
      let times++
      sleep 1
    else
      break
    fi
  done

  process=`ps -aux|awk '{print $2}' | grep ${pid}`
  if [ -n "${process}" ]; then
    echo "Server [adsprod-api] cannot stop, Please check pid file 'adsprod-api.pid' and stop it by manually!"
    exit
  fi
else
  echo "Server [adsprod-api] has been stoped!"
fi

rm -f ~/run/adsprod-api.pid