package com.bxm.adsprod.api;

import com.bxm.warcar.configure.spring.SpringBootEnvironmentListener;
import com.bxm.warcar.sc.domain.autoconfigure.EnableStaticResourceDomainRepalceHandler;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

/**
 * adsprod-api启动类
 *
 * @ClassName AdsprodApiApplication
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/7/20 18:01
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/7/20 18:01
 **/
@EnableDiscoveryClient
@EnableStaticResourceDomainRepalceHandler
@SpringBootApplication
@ComponentScan(value = "com.bxm")
@EnableConfigurationProperties(AdsprodApiProperties.class)
@EnableFeignClients("com.bxm.adsprod.facade")
public class AdsprodApiApplication {

	public static void main(String[] args) {
		SpringApplication application = new SpringApplication(AdsprodApiApplication.class);
		application.addListeners(new SpringBootEnvironmentListener());
		application.run(args);
	}

	@Bean
	public CorsFilter corsFilter() {

		final UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
		final CorsConfiguration config = new CorsConfiguration();
		config.setAllowCredentials(true); // 允许cookies跨域
		config.addAllowedHeader("*");// #允许访问的头信息,*表示全部
		config.addAllowedOrigin("*");// #允许向该服务器提交请求的URI，*表示全部允许，在SpringMVC中，如果设成*，会自动转成当前请求头中的Origin
		config.setMaxAge(18000L);// 预检请求的缓存时间（秒），即在这个时间段里，对于相同的跨域请求不会再预检了
		config.addAllowedMethod("OPTIONS");// 允许提交请求的方法，*表示全部允许
		config.addAllowedMethod("HEAD");
		config.addAllowedMethod("GET");// 允许Get的请求方法
		config.addAllowedMethod("PUT");
		config.addAllowedMethod("POST");
		config.addAllowedMethod("DELETE");
		config.addAllowedMethod("PATCH");
		source.registerCorsConfiguration("/**", config);
		//
		return new CorsFilter(source);
	}
}
