package com.bxm.adsprod.api.config;

import com.bxm.adsprod.api.interceptor.InitIpAddressInterceptor;
import com.bxm.adsprod.api.resolver.IpAddressResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import java.util.List;

/**
 * mvc配置
 *
 * @ClassName CorsConfig
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/7/25 15:04
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/7/25 15:04
 **/
@Configuration
public class WebMvcConfig extends WebMvcConfigurerAdapter {
    /**
     * 跨域配置
     *
     * @param registry
     * @return void
     * @throws
     * @author kk.xie
     * @date 2018/7/30 9:47
     */
    @Override
    public void addCorsMappings(CorsRegistry registry) {
        //设置允许跨域的路径
        registry.addMapping("/**")
                //设置允许跨域请求的域名
                .allowedOrigins("*")
                //是否允许证书 不再默认开启
                .allowCredentials(true)
                //设置允许的方法
                .allowedMethods("*")
                //跨域允许时间
                .maxAge(3600);
    }

    /**
     * 拦截器配置
     *
     * @param registry
     * @return void
     * @throws
     * @author kk.xie
     * @date 2018/7/30 9:47
     */
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        //这里可以添加多个拦截器
        registry.addInterceptor(initIpAddressInterceptor()) .addPathPatterns("/**").excludePathPatterns("/award/getImgCode","/award/validateCode");
        super.addInterceptors(registry);
    }
    @Bean
    public InitIpAddressInterceptor initIpAddressInterceptor() {
        return new InitIpAddressInterceptor();
    }

    /**
     * 解析器配置
     *
     * @param argumentResolvers
     * @return void
     * @throws
     * @author kk.xie
     * @date 2018/7/30 9:47
     */
    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(new IpAddressResolver());
    }
}
