package com.bxm.adsprod.api.controller;

import com.bxm.adsprod.api.constants.Constants;
import com.bxm.adsprod.api.resolver.IpAddress;
import com.bxm.adsprod.facade.ticket.*;
import com.bxm.warcar.sc.domain.StaticResourceMapping;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.helper.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/ticket")
public class AdticketController {

    private final static Logger LOGGER = LoggerFactory.getLogger(AdticketController.class);

    @Autowired
    private TicketService ticketService;

    @StaticResourceMapping
    @RequestMapping(value = "/get", method = RequestMethod.GET)
    public ResponseModel get(ViewRequest viewRequest){
        String url = Constants.DEFAULTTICKETLINK;
        try {
            url = ticketService.get(viewRequest.getTicketId()).getUrl();
        }catch (Exception e){
            LOGGER.error(e.getMessage(),e);
        }
        return ResponseModelFactory.SUCCESS(url);
    }

    /**
     * 获取广告券队列
     */
    @RequestMapping(value = "/getCoupon", method = RequestMethod.GET)
    public ResultModel getCoupon(@IpAddress TicketCouponRequest ticketCouponRequest) throws NoValidTicketException {
        try {
            if(StringUtils.isBlank(ticketCouponRequest.getUid())){
                ticketCouponRequest.setUid(ticketCouponRequest.getImei());
            }
            List<TicketCoupon> ticketCoupons = ticketService.getCoupon(ticketCouponRequest);
            ResultModel resultModel = ResultModelFactory.SUCCESS(List.class);
            resultModel.setReturnValue(ticketCoupons);
            return resultModel;
        }catch (Exception e){
            LOGGER.error("getCoupon error",e);
            return ResultModelFactory.SUCCESS();
        }
    }

    /**
     * 校验前端缓存的票券码是否可删除
     */
    @RequestMapping(value = "/checkCoupon", method = RequestMethod.POST)
    public ResultModel checkCoupon(@RequestBody CheckCouponRequest checkCouponRequest) throws NoValidTicketException {
        try {
            List<CheckCoupon> checkCoupons = ticketService.checkCoupon(checkCouponRequest);
            ResultModel resultModel = ResultModelFactory.SUCCESS(List.class);
            resultModel.setReturnValue(checkCoupons);
            return resultModel;
        }catch (Exception e){
            LOGGER.error("checkCoupon error",e);
            return ResultModelFactory.SUCCESS();
        }
    }

    /**
     * 获取激励视频
     */
    @RequestMapping(value = "/getInspire", method = RequestMethod.GET)
    public ResultModel getInspire(@IpAddress TicketInspireRequest ticketInspireRequest) throws NoValidTicketException {
        try {
            if(StringUtils.isBlank(ticketInspireRequest.getUid())){
                ticketInspireRequest.setUid(ticketInspireRequest.getImei());
            }
            TicketInspire ticketInspire = ticketService.getInspire(ticketInspireRequest);
            ResultModel resultModel = ResultModelFactory.SUCCESS(TicketInspire.class);
            resultModel.setReturnValue(ticketInspire);
            return resultModel;
        }catch (Exception e){
            LOGGER.error("getInspire error",e);
            return ResultModelFactory.SUCCESS();
        }
    }

    /**
     * 获取激励视频-对外API
     */
    @RequestMapping(value = "/getInspireVideo", method = RequestMethod.POST)
    public ResultModel getInspireVideo(@RequestBody TicketInspireApiRequest request) throws NoValidTicketException {
        try {
            TicketInspireApi ticketInspire = ticketService.getInspireVideo(request);
            ResultModel resultModel = ResultModelFactory.SUCCESS(TicketInspireApi.class);
            resultModel.setReturnValue(ticketInspire);
            return resultModel;
        }catch (Exception e){
            LOGGER.error("getInspireVideo error",e);
            return ResultModelFactory.SUCCESS();
        }
    }
}
