package com.bxm.adsprod.api.controller;

import com.bxm.adsprod.api.constants.Constants;
import com.bxm.adsprod.facade.award.*;
import com.bxm.adsprod.facade.ticket.Os;
import com.bxm.adsprod.facade.ticket.TicketOutsideService;
import com.bxm.monitor.util.impl.CodeValidateImgServiceImpl;
import com.bxm.warcar.sc.domain.StaticResourceMapping;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 抽奖控制器
 *
 * @ClassName AwardController
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/7/20 18:01
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/7/20 18:01
 **/
@RestController
@RequestMapping("/award")
public class AwardController{

    Logger logger = LoggerFactory.getLogger(AwardController.class);

    @Autowired
    private AwardService awardService;

    @Autowired
    private TicketOutsideService ticketOutsideService;

    @Autowired
    private CodeValidateImgServiceImpl codeValidateImgServiceImpl;

    private final Award[] backupsForIos;
    private final Award[] backupsForAndroid;

    public AwardController() {
        backupsForIos = new Award[] { create14503(), create14504() };
        backupsForAndroid = new Award[] { create14503(), create14504() };
    }

    private Award create14503() {
        Award o = new Award();
        o.setAssetsId(11512L);
        o.setAwardangle("300");
        o.setAwardid(14503L);
        o.setAwardimg("https://m.cudaojia.com/dist/ACTIVITY/certificate/2019/01/09/1c9c91f2-8b9e-4fae-9316-170cbc9e15f2.gif");
        o.setAwardlink("https://lp.tandehao.com/dist/adPages/P100/index01.html");
        o.setAwardname("福利0元购，关注领大奖！");
        o.setAwardtype(2);
        o.setButtontext("立即领取");
        o.setIsShieldPopup("0");
        o.setLandingType(0);
        o.setShopstype(59);
        o.setValiditytime("2099-01-01");
        return o;
    }

    private Award create14504() {
        Award o = new Award();
        o.setAssetsId(11514L);
        o.setAwardangle("300");
        o.setAwardid(14504L);
        o.setAwardimg("https://m.cudaojia.com/dist/ACTIVITY/certificate/2019/01/09/639f45dc-5503-4089-871a-1ecfe8b1b178.gif");
        o.setAwardlink("https://lp.tandehao.com/dist/adPages/P100/index01.html");
        o.setAwardname("福利0元购，关注领大奖！");
        o.setAwardtype(2);
        o.setButtontext("立即领取");
        o.setIsShieldPopup("0");
        o.setLandingType(0);
        o.setShopstype(59);
        o.setValiditytime("2099-01-01");
        return o;
    }

    /**
     * 抽奖接口   get
     *
   * @param awardDto
     * @return com.bxm.adsprod.model.vo.ResponseModel
     * @throws
     * @author kk.xie
     * @date 2018/7/23 14:59
     */
    @StaticResourceMapping
    @RequestMapping(value = "/awardInfo", method = RequestMethod.POST)
    public ResponseModel awardInfo(AwardDto awardDto){
        try {
            // 获取礼券
            Award award = awardService.get(awardDto);

            // 返回礼券
            return ResponseModelFactory.SUCCESS(award);
        } catch (Exception e) {
            logger.error("获取广告券发生异常！", e);

            Award backup;
            int os = NumberUtils.toInt(awardDto.getAppos(), Os.ANDROID);
            if (os == Os.IOS) {
                backup = backupsForIos[RandomUtils.nextInt(backupsForIos.length)];
            } else {
                backup = backupsForAndroid[RandomUtils.nextInt(backupsForAndroid.length)];
            }
            return ResponseModelFactory.SUCCESS(backup);
        }
    }

    /**
     * 中奖后回调接口，录入中奖用户的基本信息  fetch
     *
     * @param acceptAwardDto
     * @return com.bxm.adsprod.model.vo.ResponseModel
     * @throws
     * @author kk.xie
     * @date 2018/7/25 11:27
     */
    @RequestMapping(value = "/fetchAward", method = RequestMethod.POST)
    public ResponseModel fetchAward(FetchAwardDto acceptAwardDto){
        boolean success = awardService.fetch(acceptAwardDto);
        if(success){
            return ResponseModelFactory.getResponseModel();
        }else{
            return ResponseModelFactory.FAILED();
        }
    }

    /**
     * 查询用户的中奖信息 user
     *
     * @param userAwardDto
     * @return com.bxm.warcar.utils.response.ResponseModel
     * @throws
     * @author kk.xie
     * @date 2018/7/27 16:52
     */
    @StaticResourceMapping
    @RequestMapping(value = "/userAwardList", method = RequestMethod.GET)
    public ResponseModel userAwardList(UserAwardDto userAwardDto){
        List<UserAwardVo> userAwardVoList = awardService.fetchUserAward(userAwardDto);
        return ResponseModelFactory.SUCCESS(userAwardVoList);
    }

    /**
     * 素材直投
     *
     * @param outSideDto
     * @param response
     * @return void
     * @throws
     * @author kk.xie
     * @date 2018/8/15 11:14
     */
    @RequestMapping(value = "/putInfo", method = RequestMethod.GET)
    public void putInfo(OutSideDto outSideDto, HttpServletRequest request, HttpServletResponse response){
        String url = Constants.DEFAULTTICKETLINK;

        if(StringUtils.isEmpty(outSideDto.getAssetId())){
            logger.warn("assetId is Empty");
        }else{
            try {
                String userAgent = request.getHeader("User-Agent");
                String referrer = request.getHeader("Referer");
                //url = ticketOutsideService.getTicketUrl(outSideDto.getAssetId(), outSideDto.getIpaddress());
                url = ticketOutsideService.getNewTicketUrl(outSideDto.getAssetId(), outSideDto.getIpaddress(), outSideDto.getIsSupplement(),
                        userAgent, referrer);
            } catch (Exception e) {
                logger.error("ticketOutsideService.getTicketUrl error", e);
            }
        }
        try {
            response.sendRedirect(url);
        } catch (IOException e) {
            logger.error("AwardController.putInfo sendRedirect error", e);
        }
    }


    /**
     * 获取图片验证码
     *
     * @return ValidateImgInfo
     * @throws
     * @author 拉拉
     * @date 2018/8/15 11:14
     */
    @RequestMapping(value = "/getImgCode", method = RequestMethod.GET)
    public ResponseModel getImgCode(HttpServletRequest req){
        return  ResponseModelFactory.SUCCESS(codeValidateImgServiceImpl.getValidateImgInfo(req));
    }

    /**
     * 校验图片验证码
     *
     * @return ValidateImgInfo
     * @throws
     * @author 拉拉
     * @date 2018/8/15 11:14
     */
    @RequestMapping(value = "/validateCode", method = RequestMethod.GET)
    public ResponseModel validateCode(HttpServletRequest req){
        Boolean b=codeValidateImgServiceImpl.validateCode(req);
        if(b){
            return  ResponseModelFactory.SUCCESS(b,1,"校验成功");
        }
        return  ResponseModelFactory.SUCCESS(b,1,"校验失败");
    }
}
