package com.bxm.adsprod.api.controller;

import com.bxm.adsprod.api.service.MiSportService;
import com.bxm.adsprod.api.service.Signature;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author allen
 * @since 1.0.0
 */
@RestController
@RequestMapping("/mi_sport")
public class MiSportController {

    private static final Logger LOGGER = LoggerFactory.getLogger(MiSportController.class);
    private final MiSportService miSportService;

    public MiSportController(MiSportService miSportService) {
        this.miSportService = miSportService;
    }

    @RequestMapping(value = "/get_sign", method = RequestMethod.POST)
    public ResponseModel getSignature(@RequestParam("url") String url) {
        try {
            Signature signature = miSportService.signature(url);
            return ResponseModelFactory.SUCCESS(signature);
        } catch (Exception e) {
            LOGGER.error("signature", e);
            ResponseModel<Object> responseModel = ResponseModelFactory.FAILED500();
            responseModel.setMessage(e.getMessage());
            return responseModel;
        }
    }
}
