package com.bxm.adsprod.api.controller;

import com.bxm.adsprod.facade.media.UserMedia;
import com.bxm.adsprod.facade.media.UserMediaRequest;
import com.bxm.adsprod.facade.media.UserMediaService;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * <h3>开发者的用户信息</h3>
 *
 * @author kerry.jiang
 * @date 2019-9-3 11:17
 */
@RestController
@RequestMapping("/usermedia")
public class UserMediaController {

    @Autowired
    private UserMediaService userMediaService;

    /**
     * SDK登录
     */
    @RequestMapping(value = "/login", method = RequestMethod.POST)
    public ResultModel login(@RequestBody UserMediaRequest userMediaRequest) {
        if(Boolean.FALSE == userMediaRequest.getAppkey().equals(userMediaRequest.getPosition_id().split("-")[0])){
            ResultModel resultModel = ResultModelFactory.FAILED400();
            resultModel.setErrorDesc("appkey与position_id不匹配");
            return resultModel;
        }
        UserMedia userMedia = userMediaService.login(userMediaRequest);
        return ResultModelFactory.SUCCESS(userMedia);
    }
}
