package com.bxm.adsprod.api.controller;

import com.bxm.adsprod.api.config.VideoReportConfiguration;
import com.bxm.adsprod.api.constants.Constants;
import com.bxm.adsprod.common.utils.OkHttpUtils;
import com.bxm.adsprod.facade.resolve.UrlParamResolver;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.video.EquipmentRedordDto;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.IpHelper;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zm
 * @Date: 2019/8/1  16:02
 * @Description: 激励视频数据上报controller
 */
@RestController
@RequestMapping("/video-report")
public class VideoReportController {


    @Autowired
    private VideoReportConfiguration videoReportConfiguration;

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    private Logger logger = LoggerFactory.getLogger(VideoReportController.class);


    /**
     * 上传设备公参
     *
     * @return
     */
    @PostMapping("/equipment")
    public ResultModel addEquipment(HttpServletRequest request, @RequestBody EquipmentRedordDto redordDto) {
        //获取ip
        String ip;
        try {
            ip = (String) request.getAttribute(Constants.IP_FIELD_NAME);
        } catch (Exception e) {
            ip = IpHelper.getIpFromHeader(request);
        }
        //接口调用
        if (StringUtils.isNotBlank(ip)) {
            redordDto.setIpaddress(ip);
        }
        try {
            String resultBody = OkHttpUtils.post(videoReportConfiguration.getSdkUrl(), UrlParamResolver.generatePostParam(redordDto));
            if (logger.isDebugEnabled()) {
                logger.debug("调用设备公参上报接口返回结果：{}", resultBody);
            }
            //存储redis数据
            if (StringUtils.isNotBlank(redordDto.getImei()) && StringUtils.isNotBlank(redordDto.getApplications())) {
                updater.hupdate(TicketKeyGenerator.User.getInstalledAppList(), redordDto.getImei(), redordDto.getApplications());
            }
        } catch (Exception e) {
            //调用失败 是否进行定时重试 或者数据保存
            logger.error("sdk  equipment report error", e);
        }
        //返回
        return ResultModelFactory.SUCCESS();
    }

}
