package com.bxm.adsprod.api.interceptor;

import com.alibaba.fastjson.JSONArray;
import com.bxm.adsprod.api.constants.Constants;
import com.bxm.monitor.util.commons.DateUtil;
import com.bxm.monitor.util.impl.CodeValidateImgServiceImpl;
import com.bxm.warcar.utils.HttpUtils;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;

/**
 * 初始化ip的拦截器
 *
 * @ClassName InitIpAddressInterceptor
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/7/26 16:25
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/7/26 16:25
 **/
@Component
public class InitIpAddressInterceptor extends HandlerInterceptorAdapter {

    @Resource
    private CodeValidateImgServiceImpl cs;
    /**
     * 在控制器执行前调用
     * This implementation always returns {@code true}.
     */
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
            throws Exception {
        String ipAddress = HttpUtils.getIpFromHeader(request);
        request.setAttribute(Constants.IP_FIELD_NAME, ipAddress);
        //这个是全局拦截器
        //判断时间在出验证码的时间范围内
        if (cs != null) {
            String startAndEndTime = cs.getStartAndEndTime();
            if (StringUtils.isNotEmpty(startAndEndTime)) {
                //判断时间在缓存的区间范围内
                if (DateUtil.isBelong(startAndEndTime.split(",")[0], startAndEndTime.split(",")[1])) {
                    //判断是否出验证码
                    if (cs.isCodeValidateImg(request)) {
                        PrintWriter out = response.getWriter();
                        out.println(JSONArray.toJSON(ResponseModelFactory.SUCCESS(true,11,"true")));
                        out.flush();
                        out.close();
                        return false;
                    }
                }
            }
        }

        return true;
    }

    /**
     * 在后端控制器执行后调用
     * This implementation is empty.
     */
    @Override
    public void postHandle(
            HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView)
            throws Exception {
    }

    /**
     * 整个请求执行完成后调用
     * This implementation is empty.
     */
    @Override
    public void afterCompletion(
            HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex)
            throws Exception {
    }

    /**
     * Called instead of {@code postHandle} and {@code afterCompletion}, when
     * the a handler is being executed concurrently.
     * <p>Implementations may use the provided request and response but should
     * avoid modifying them in ways that would conflict with the concurrent
     * execution of the handler. A typical use of this method would be to
     * clean up thread-local variables.
     */
    @Override
    public void afterConcurrentHandlingStarted(
            HttpServletRequest request, HttpServletResponse response, Object handler)
            throws Exception {
    }
}
