package com.bxm.adsprod.api.resolver;

import com.bxm.adsprod.api.constants.Constants;
import com.bxm.adsprod.facade.award.AwardDto;
import com.bxm.adsprod.facade.award.OutSideDto;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

import java.lang.reflect.Field;

/**
 * ip 解析器
 *
 * @ClassName IpAddressResolver
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/7/26 17:06
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/7/26 17:06
 **/
@Component
public class IpAddressResolver implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType().equals(AwardDto.class) || parameter.getParameterType().equals(OutSideDto.class)
                || parameter.hasParameterAnnotation(IpAddress.class);
    }

    /**
     * 拦截参数，进行解析
     *
     * @param parameter
   * @param mavContainer
   * @param webRequest
   * @param binderFactory
     * @return java.lang.Object
     * @throws
     * @author kk.xie
     * @date 2018/7/26 19:19
     */
    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        // 参数类型
        Class<?> targetType = parameter.getParameterType();
        // 取对象的所有属性
        Field[] fields = targetType.getDeclaredFields();
        Object arg = null;
        // 创建对象
        Object target = targetType.newInstance();
        WebDataBinder binder = binderFactory.createBinder(webRequest, null, "");
        for (Field field : fields) {
            field.setAccessible(true);
            String fieldName = field.getName();
            Class<?> fieldType = field.getType();
            if(Constants.IP_FIELD_NAME.equals(fieldName)){
                // 赋值IP
                arg = binder.convertIfNecessary(webRequest.getAttribute(Constants.IP_FIELD_NAME, 0), fieldType, parameter);
            }else{
                arg = binder.convertIfNecessary(webRequest.getParameter(fieldName), fieldType, parameter);
            }
            if(arg != null){
                field.set(target, arg);
            }
        }
        return target;
    }
}
