package com.bxm.adsprod.api.service;

import com.bxm.adsprod.api.AdsprodApiProperties;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.StringHelper;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Maps;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author allen
 * @since 1.0.0
 */
@Service
public class DefaultMiSportServiceImpl implements MiSportService {

    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMiSportServiceImpl.class);
    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    @Autowired
    private AdsprodApiProperties properties;

    private final RestTemplate rest = new RestTemplateBuilder().setConnectTimeout(5000).build();

    @Override
    public String getToken() {
        return fetcher.fetch(() -> KeyBuilder.build("TMP", "MISPORT", "ACCESS_TOKEN"),
                this::getToken0,
                String.class,
                7000);
    }

    private String getToken0() {
        AdsprodApiProperties.Mi mi = properties.getMi();

        MultiValueMap<String, String> form = new LinkedMultiValueMap<>();
        form.add("appkey", mi.getAppkey());
        form.add("appsecret", mi.getAppsecret());

        ResponseEntity<AccessTokenResponse> entity = rest.postForEntity(mi.getAccessTokenUrl(), form, AccessTokenResponse.class);
        AccessTokenResponse body = entity.getBody();
        if (null == body) {
            LOGGER.warn("没有获取到正确的内容");
            return null;
        }
        String accessToken = body.getAccess_token();
        if (StringUtils.isBlank(accessToken)) {
            LOGGER.warn("没有获取到正确的AccessToken，响应：{}", body);
            return null;
        }
        return accessToken;
    }

    @Override
    public Signature signature(String url) {
        String token = getToken();
        if (StringUtils.isBlank(token)) {
            throw new RuntimeException("access_token does not exist!");
        }
        Map<String, String> param = Maps.newTreeMap();
        String appkey = properties.getMi().getAppkey();
        param.put("appkey", appkey);
        String nonce = StringHelper.random(15);
        param.put("noncestr", nonce);
        param.put("access_token", token);
        String time = TypeHelper.castToString(System.currentTimeMillis() / 1000);
        param.put("timestamp", time);
        param.put("url", url);
        String source = convert(param);
        String sign = DigestUtils.sha1Hex(source);
        return new Signature(appkey, time, nonce, sign);
    }

    private String convert(Map<String, String> param) {
        StringBuilder str = new StringBuilder();
        Set<Map.Entry<String, String>> entries = param.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            str.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        return StringUtils.removeEnd(str.toString(), "&");
    }

    public static final class AccessTokenResponse implements Serializable {

        private static final long serialVersionUID = 3439605826047616977L;
        private String access_token;
        private Integer expires_in;
        private Integer error_code;
        private String error_massage;

        String getAccess_token() {
            return access_token;
        }

        public void setAccess_token(String access_token) {
            this.access_token = access_token;
        }

        public Integer getExpires_in() {
            return expires_in;
        }

        public void setExpires_in(Integer expires_in) {
            this.expires_in = expires_in;
        }

        public Integer getError_code() {
            return error_code;
        }

        public void setError_code(Integer error_code) {
            this.error_code = error_code;
        }

        public String getError_massage() {
            return error_massage;
        }

        public void setError_massage(String error_massage) {
            this.error_massage = error_massage;
        }

        @Override
        public String toString() {
            return "AccessTokenResponse{" +
                    "access_token='" + access_token + '\'' +
                    ", expires_in=" + expires_in +
                    ", error_code=" + error_code +
                    ", error_massage='" + error_massage + '\'' +
                    '}';
        }
    }
}
