package com.bxm.adsprod.api.validation;

import com.bxm.warcar.validate.ValidateException;
import com.bxm.warcar.validate.Validator;
import com.bxm.warcar.validate.factory.AnnotationValidatorFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

/**
 * 参数校验
 *
 * @ClassName ValidateAspect
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/7/25 16:48
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/7/25 16:48
 **/
@Aspect
@Order(-1)
@Component
public class ValidateAspect {
    private final AnnotationValidatorFactory annotationValidatorFactory = new AnnotationValidatorFactory();

    @Pointcut("execution(* com.bxm.adsprod.api.controller.*Controller.*(..))")
    public void pointCut(){}

    @Before("pointCut()")
    public void before(JoinPoint point)  {
        Object[] args = point.getArgs();
        for (Object arg : args) {
            if (null == arg) {
                continue;
            }
            Validator validator = annotationValidatorFactory.create(arg.getClass());
            if (null != validator) {
                validator.validate(arg);
            }
        }
    }
}
