package com.bxm.adsprod.counter.ticket;

import com.bxm.adsprod.counter.properties.Configuration;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

import java.math.BigInteger;

/**
 * <h3>曝光次数统计</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/11
 */
@EnableConfigurationProperties(Configuration.class)
public abstract class AbstractViewCounter extends AbstractCounter<ViewRequest, Ticket> {

    @Autowired
    protected Configuration local;

    @Override
    protected ViewRequest convertRequest(Object request) {
        return (ViewRequest) request;
    }

    @Override
    protected Ticket convertReturning(Object returning) {
        return (Ticket) returning;
    }

    @Override
    protected long getIncrementValue(ViewRequest ticketRequest, Ticket ticket) {
        return DEFAULT_INCREMENT_VALUE;
    }

    @Override
    protected String getUid(ViewRequest ticketRequest, Ticket ticket) {
        return ticketRequest.getUid();
    }

    @Override
    protected BigInteger getTicketId(ViewRequest ticketRequest, Ticket ticket) {
        return ticket.getId();
    }

    @Override
    public String getTopic() {
        return local.getTopic().getView();
    }

}
